/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import wayoftime.bloodmagic.common.item.ITeleposerFocus;
import wayoftime.bloodmagic.common.item.ItemBindableBase;
import wayoftime.bloodmagic.common.tile.TileTeleposer;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.event.ItemBindEvent;
import wayoftime.bloodmagic.util.helper.BindableHelper;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class ItemTeleposerFocus
extends ItemBindableBase
implements ITeleposerFocus {
    public final int range;

    public ItemTeleposerFocus(int range) {
        this.range = range;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        if (world.m_7702_(pos) instanceof TileTeleposer) {
            ItemBindEvent toPost;
            this.setStoredPos(stack, pos);
            this.setWorld(stack, world);
            Binding binding = this.getBinding(stack);
            if (binding == null && this.onBind(player, stack) && !MinecraftForge.EVENT_BUS.post((Event)(toPost = new ItemBindEvent(player, stack)))) {
                BindableHelper.applyBinding(stack, player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void setStoredPos(ItemStack stack, BlockPos pos) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag tag = stack.m_41783_();
        tag.m_128405_("xCoord", pos.m_123341_());
        tag.m_128405_("yCoord", pos.m_123342_());
        tag.m_128405_("zCoord", pos.m_123343_());
    }

    @Override
    public BlockPos getStoredPos(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag tag = stack.m_41783_();
        return new BlockPos(tag.m_128451_("xCoord"), tag.m_128451_("yCoord"), tag.m_128451_("zCoord"));
    }

    public void setWorld(ItemStack stack, Level world) {
        String worldKey = world.m_46472_().m_135782_().toString();
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128359_("world", worldKey);
    }

    public ResourceKey<Level> getStoredKey(ItemStack stack, Level world) {
        if (!stack.m_41782_()) {
            return null;
        }
        String worldKey = stack.m_41783_().m_128461_("world");
        ResourceKey registryKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(worldKey));
        return registryKey;
    }

    @Override
    public Level getStoredWorld(ItemStack stack, Level world) {
        ResourceKey<Level> registryKey = this.getStoredKey(stack, world);
        if (registryKey == null || world.m_7654_() == null) {
            return null;
        }
        return world.m_7654_().m_129880_(registryKey);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        ResourceKey<Level> storedKey = this.getStoredKey(stack, world);
        if (storedKey != null) {
            BlockPos storedPos = this.getStoredPos(stack);
            tooltip.add((Component)Component.m_237115_((String)TextHelper.localizeEffect("tooltip.bloodmagic.telepositionfocus.coords", storedPos.m_123341_(), storedPos.m_123342_(), storedPos.m_123343_())).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.bloodmagic.telepositionfocus.world", (Object[])new Object[]{Component.m_237115_((String)storedKey.m_135782_().toString())}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public AABB getEntityRangeOffset(Level world, BlockPos teleposerPos) {
        return new AABB((double)(-this.range), 1.0, (double)(-this.range), (double)(this.range + 1), (double)(2 * this.range + 2), (double)(this.range + 1));
    }

    @Override
    public List<BlockPos> getBlockListOffset(Level world) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int i = -this.range; i <= this.range; ++i) {
            for (int j = 1; j <= 2 * this.range + 1; ++j) {
                for (int k = -this.range; k <= this.range; ++k) {
                    posList.add(new BlockPos(i, j, k));
                }
            }
        }
        return posList;
    }
}

