/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import wayoftime.bloodmagic.common.item.ItemBindableBase;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class ItemLavaCrystal
extends ItemBindableBase {
    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        Binding binding = this.getBinding(stack);
        if (binding != null) {
            NetworkHelper.getSoulNetwork(binding.getOwnerId()).syphon(SoulTicket.item(stack, 50));
        }
        ItemStack returnStack = new ItemStack((ItemLike)this);
        returnStack.m_41751_(stack.m_41783_());
        return returnStack;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public int getBurnTime(ItemStack stack) {
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return -1;
        }
        if (EffectiveSide.get().isServer()) {
            if (NetworkHelper.canSyphonFromContainer(stack, 50)) {
                return 200;
            }
            Player player = PlayerHelper.getPlayerFromUUID(binding.getOwnerId());
            if (player != null) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 99));
            }
        } else {
            return 200;
        }
        return -1;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        pos = pos.m_121945_(facing);
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        ItemStack itemstack = player.m_21120_(hand);
        Binding binding = this.getBinding(player.m_21120_(hand));
        if (binding == null) {
            return InteractionResult.FAIL;
        }
        if (!player.m_36204_(pos, facing, itemstack)) {
            return InteractionResult.FAIL;
        }
        if (context.m_43725_().m_46859_(pos) && context.m_43725_().f_46443_) {
            context.m_43725_().m_5594_(player, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, context.m_43725_().m_213780_().m_188501_() * 0.4f + 0.8f);
            return InteractionResult.SUCCESS;
        }
        if (!context.m_43725_().m_46859_(pos) || !NetworkHelper.getSoulNetwork(binding).syphonAndDamage(player, SoulTicket.item(player.m_21120_(hand), 100)).isSuccess()) {
            return InteractionResult.FAIL;
        }
        context.m_43725_().m_5594_(player, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, context.m_43725_().m_213780_().m_188501_() * 0.4f + 0.8f);
        context.m_43725_().m_7731_(pos, Blocks.f_50083_.m_49966_(), 11);
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, pos, itemstack);
        }
        return InteractionResult.SUCCESS;
    }
}

