/*
 * Decompiled with CFR 0.152.
 */
package reliquary.pedestal.wrappers;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.FakePlayer;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItemWrapper;
import reliquary.reference.Settings;

public class PedestalMeleeWeaponWrapper
implements IPedestalActionItemWrapper {
    private final int cooldownAfterSwing;

    public PedestalMeleeWeaponWrapper() {
        this.cooldownAfterSwing = (Integer)Settings.COMMON.blocks.pedestal.meleeWrapperCooldown.get();
    }

    @Override
    public void update(ItemStack stack, Level level, IPedestal pedestal) {
        BlockPos pos = pedestal.getBlockPosition();
        int meleeRange = (Integer)Settings.COMMON.blocks.pedestal.meleeWrapperRange.get();
        List entities = level.m_45976_(Mob.class, new AABB((double)pos.m_123341_() - (double)meleeRange, (double)pos.m_123342_() - (double)meleeRange, (double)pos.m_123343_() - (double)meleeRange, (double)pos.m_123341_() + (double)meleeRange, (double)pos.m_123342_() + (double)meleeRange, (double)pos.m_123343_() + (double)meleeRange));
        if (entities.isEmpty()) {
            pedestal.setActionCoolDown(40);
            return;
        }
        Mob entityToAttack = (Mob)entities.get(level.f_46441_.m_188503_(entities.size()));
        while (!entities.isEmpty() && !this.canAttackEntity(entityToAttack)) {
            entities.remove(entityToAttack);
            if (entities.isEmpty()) continue;
            entityToAttack = (Mob)entities.get(level.f_46441_.m_188503_(entities.size()));
        }
        if (entities.isEmpty()) {
            pedestal.setActionCoolDown(40);
            return;
        }
        Mob finalEntityToAttack = entityToAttack;
        pedestal.getFakePlayer().ifPresent(fakePlayer -> this.attackEntity(stack, pedestal, pos, finalEntityToAttack, (FakePlayer)fakePlayer));
        if (stack.m_41619_()) {
            pedestal.destroyItem();
        }
    }

    private void attackEntity(ItemStack stack, IPedestal pedestal, BlockPos pos, Mob entityToAttack, FakePlayer fakePlayer) {
        fakePlayer.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, stack);
        fakePlayer.m_8119_();
        fakePlayer.m_5706_((Entity)entityToAttack);
        entityToAttack.m_6703_(null);
        pedestal.setActionCoolDown((int)fakePlayer.m_36333_() + this.cooldownAfterSwing);
    }

    private boolean canAttackEntity(Mob entityToAttack) {
        TamableAnimal tamableAnimal;
        Horse horse;
        return !(entityToAttack instanceof Villager || entityToAttack instanceof Animal && entityToAttack.m_6162_() || entityToAttack instanceof Horse && (horse = (Horse)entityToAttack).m_30614_() || entityToAttack instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entityToAttack).m_21824_());
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, Level level, IPedestal pedestal) {
    }
}

