/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity.potion;

import java.util.List;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import reliquary.init.ModEntities;
import reliquary.init.ModItems;
import reliquary.item.util.IPotionItem;
import reliquary.network.PacketFXThrownPotionImpact;
import reliquary.network.PacketHandler;
import reliquary.util.potions.XRPotionHelper;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class ThrownXRPotionEntity
extends ThrowableProjectile
implements IEntityAdditionalSpawnData,
ItemSupplier {
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.m_135353_(ThrownXRPotionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public ThrownXRPotionEntity(EntityType<ThrownXRPotionEntity> entityType, Level world) {
        super(entityType, world);
    }

    public ThrownXRPotionEntity(Level world, double x, double y, double z, ItemStack potion) {
        super((EntityType)ModEntities.THROWN_POTION.get(), x, y, z, world);
        this.setItem(potion);
    }

    public ThrownXRPotionEntity(Level world, LivingEntity entity, ItemStack potion) {
        super((EntityType)ModEntities.THROWN_POTION.get(), entity, world);
        this.setItem(potion);
    }

    protected float m_7139_() {
        return 0.04f;
    }

    protected void m_6532_(HitResult result) {
        if (!this.m_9236_().f_46443_) {
            ItemStack potion = this.m_7846_();
            if (!(potion.m_41720_() instanceof IPotionItem)) {
                return;
            }
            List<MobEffectInstance> effects = ((IPotionItem)potion.m_41720_()).getEffects(potion);
            int color = PotionUtils.m_43564_(effects);
            if (potion.m_41720_() == ModItems.LINGERING_POTION.get()) {
                this.spawnAreaEffectCloud(effects, color);
            } else {
                this.splashPotion(result, effects);
            }
            this.spawnParticles(color);
            this.m_146870_();
        }
    }

    private void splashPotion(HitResult result, List<MobEffectInstance> effects) {
        AABB axisalignedbb = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
        List livingEntities = this.m_9236_().m_45976_(LivingEntity.class, axisalignedbb);
        if (!livingEntities.isEmpty()) {
            for (LivingEntity entity : livingEntities) {
                double d0 = this.m_20270_((Entity)entity);
                if (!(d0 < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                if (result.m_6662_() == HitResult.Type.ENTITY && entity == ((EntityHitResult)result).m_82443_()) {
                    d1 = 1.0;
                }
                XRPotionHelper.applyEffectsToEntity(effects, (Entity)this, this.m_19749_(), entity, d1);
            }
        }
    }

    private void spawnAreaEffectCloud(List<MobEffectInstance> effects, int color) {
        AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            areaEffectCloud.m_19718_(livingEntity);
        }
        areaEffectCloud.m_19712_(3.0f);
        areaEffectCloud.m_19732_(-0.5f);
        areaEffectCloud.m_19740_(10);
        areaEffectCloud.m_19738_(-areaEffectCloud.m_19743_() / (float)areaEffectCloud.m_19748_());
        areaEffectCloud.m_19714_(color);
        for (MobEffectInstance potionEffect : effects) {
            areaEffectCloud.m_19716_(new MobEffectInstance(potionEffect.m_19544_(), potionEffect.m_19557_(), potionEffect.m_19564_()));
        }
        this.m_9236_().m_7967_((Entity)areaEffectCloud);
    }

    private void spawnParticles(int color) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        RandomSource var7 = this.f_19796_;
        for (int var15 = 0; var15 < 8; ++var15) {
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), var7.m_188583_() * 0.15, var7.m_188500_() * 0.2, var7.m_188583_() * 0.15);
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, this.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f);
        PacketHandler.sendToAllAround(new PacketFXThrownPotionImpact(color, this.m_20185_(), this.m_20186_(), this.m_20189_()), new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 32.0, this.m_9236_().m_46472_()));
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("item", (Tag)this.m_7846_().m_41739_(new CompoundTag()));
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setItem(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("item")));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ITEM, (Object)ItemStack.f_41583_);
    }

    public ItemStack m_7846_() {
        return (ItemStack)this.f_19804_.m_135370_(ITEM);
    }

    private void setItem(ItemStack stack) {
        this.f_19804_.m_135381_(ITEM, (Object)stack);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.m_7846_());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.setItem(additionalData.m_130267_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

