/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.ForgeRegistries;
import reliquary.init.ModItems;
import reliquary.item.MobCharmFragmentItem;

public class FragmentRecipeHelper {
    public static final Item FALL_BACK_SPAWN_EGG = Items.f_42552_;

    private FragmentRecipeHelper() {
    }

    public static boolean hasOnlyOneFragmentType(CraftingContainer inv) {
        String regName = null;
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack slotStack = inv.m_8020_(slot);
            if (slotStack.m_41720_() != ModItems.MOB_CHARM_FRAGMENT.get()) continue;
            if (regName == null) {
                regName = MobCharmFragmentItem.getEntityRegistryName(slotStack);
                continue;
            }
            if (regName.equals(MobCharmFragmentItem.getEntityRegistryName(slotStack))) continue;
            return false;
        }
        return true;
    }

    public static Optional<String> getRegistryName(CraftingContainer inv) {
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack slotStack = inv.m_8020_(slot);
            if (slotStack.m_41720_() != ModItems.MOB_CHARM_FRAGMENT.get()) continue;
            return Optional.of(MobCharmFragmentItem.getEntityRegistryName(slotStack));
        }
        return Optional.empty();
    }

    public static ItemStack getSpawnEggStack(String regName) {
        SpawnEggItem spawnEggItem = ForgeSpawnEggItem.fromEntityType((EntityType)((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(regName))));
        return new ItemStack((ItemLike)(spawnEggItem == null ? FALL_BACK_SPAWN_EGG : spawnEggItem));
    }
}

