/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.util;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import tcintegrations.common.capabilities.CapabilityRegistry;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.entity.PixieEntity;
import vazkii.botania.xplat.XplatAbstractions;

public class BotaniaHelper {
    private static final MobEffect[] potions = new MobEffect[]{MobEffects.f_19610_, MobEffects.f_19615_, MobEffects.f_19597_, MobEffects.f_19613_};

    public static void spawnPixie(ServerPlayer sp, ItemStack stack, LivingEntity target) {
        PixieEntity pixie = new PixieEntity(sp.m_9236_());
        pixie.m_6034_(sp.m_20185_(), sp.m_20186_() + 2.0, sp.m_20189_());
        if (BotaniaHelper.hasGreatFairyArmorSet((Player)sp)) {
            pixie.setApplyPotionEffect(new MobEffectInstance(potions[sp.m_9236_().f_46441_.m_188503_(potions.length)], 40, 0));
        }
        float dmg = 4.0f;
        if (!stack.m_41619_()) {
            dmg += 2.0f;
        }
        pixie.setProps(target, (LivingEntity)sp, 0, dmg);
        pixie.m_6518_((ServerLevelAccessor)sp.m_9236_(), sp.m_9236_().m_6436_(pixie.m_20183_()), MobSpawnType.EVENT, null, null);
        sp.m_9236_().m_7967_((Entity)pixie);
    }

    public static int getManaPerDamageBonus(Player player, int mana) {
        AtomicReference<Double> decreaseModifier = new AtomicReference<Double>(1.0);
        player.getCapability(CapabilityRegistry.BOTANIA_SET_CAPABILITY).ifPresent(data -> {
            if (data.hasTerrestrial()) {
                if (data.hasAlfheim()) {
                    decreaseModifier.set(0.8);
                } else {
                    decreaseModifier.set(0.7);
                }
            } else if (data.hasGreatFairy()) {
                decreaseModifier.set(0.9);
            }
        });
        return (int)((double)mana * decreaseModifier.get());
    }

    public static boolean dispatchManaExact(ServerPlayer player, int manaToSend) {
        List items = ManaItemHandler.INSTANCE.getManaItems((Player)player);
        List acc = ManaItemHandler.INSTANCE.getManaAccesories((Player)player);
        for (ItemStack stackInSlot : Iterables.concat((Iterable)items, (Iterable)acc)) {
            ManaItem manaItemSlot = XplatAbstractions.INSTANCE.findManaItem(stackInSlot);
            if (manaItemSlot.getMana() + manaToSend > manaItemSlot.getMaxMana()) continue;
            manaItemSlot.addMana(manaToSend);
            return true;
        }
        return false;
    }

    public static boolean hasTerrestrialArmorSet(Player player) {
        AtomicBoolean hasSet = new AtomicBoolean(false);
        player.getCapability(CapabilityRegistry.BOTANIA_SET_CAPABILITY).ifPresent(data -> hasSet.set(data.hasTerrestrial()));
        return hasSet.get();
    }

    public static boolean hasGreatFairyArmorSet(Player player) {
        AtomicBoolean hasSet = new AtomicBoolean(false);
        player.getCapability(CapabilityRegistry.BOTANIA_SET_CAPABILITY).ifPresent(data -> hasSet.set(data.hasGreatFairy()));
        return hasSet.get();
    }

    public static boolean hasAlfheimArmorSet(Player player) {
        AtomicBoolean hasSet = new AtomicBoolean(false);
        player.getCapability(CapabilityRegistry.BOTANIA_SET_CAPABILITY).ifPresent(data -> hasSet.set(data.hasAlfheim()));
        return hasSet.get();
    }
}

