/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.tool;

import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.tags.ITag;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import tcintegrations.common.TagManager;
import tcintegrations.data.integration.ModIntegration;
import tcintegrations.util.TagHelper;

public class CheesyModifier
extends Modifier
implements GeneralInteractionModifierHook,
ProcessLootModifierHook {
    private static final Lazy<ItemStack> CHEESE_STACK = Lazy.of(() -> new ItemStack(CheesyModifier.getCheese()));

    private static ItemLike getCheese() {
        ITag<Item> cheeses = TagHelper.getTag(TagManager.Items.CHEESE);
        if (!cheeses.isEmpty()) {
            return (ItemLike)cheeses.getRandomElement(RandomSource.m_216327_()).orElseGet(() -> ((ItemStack)ItemStack.f_41583_).m_41720_());
        }
        return ItemStack.f_41583_.m_41720_();
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.GENERAL_INTERACT, ModifierHooks.PROCESS_LOOT);
    }

    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (source == InteractionSource.RIGHT_CLICK && !tool.isBroken() && player.m_36391_(false)) {
            GeneralInteractionModifierHook.startUsing((IToolStackView)tool, (ModifierId)modifier.getId(), (LivingEntity)player, (InteractionHand)hand);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void onFinishUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity) {
        Player player;
        if (!tool.isBroken() && entity instanceof Player && (player = (Player)entity).m_36391_(false)) {
            int level = modifier.getLevel();
            Level world = entity.m_9236_();
            player.m_36324_().m_38707_(level, (float)level * 0.1f);
            ModifierUtil.foodConsumer.onConsume(player, (ItemStack)CHEESE_STACK.get(), level, (float)level * 0.1f);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)tool.getItem()));
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 1.0f, 1.0f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.4f);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12321_, SoundSource.NEUTRAL, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
            if (ToolDamageUtil.directDamage((IToolStackView)tool, (int)(15 * level), (LivingEntity)player, (ItemStack)player.m_21211_())) {
                player.m_21190_(player.m_7655_());
            }
        }
    }

    public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return UseAnim.EAT;
    }

    public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 16;
    }

    public void processLoot(IToolStackView tool, ModifierEntry modifier, List<ItemStack> generatedLoot, LootContext context) {
        if (!context.m_78936_(LootContextParams.f_81457_)) {
            return;
        }
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (entity != null && entity.m_6095_().m_204039_(TagManager.EntityTypes.MILK_PRODUCER)) {
            int looting = context.getLootingModifier();
            if (RANDOM.nextInt(48 / modifier.intEffectiveLevel()) <= looting) {
                generatedLoot.add(new ItemStack((ItemLike)ModIntegration.BEYOND_EARTH_CHEESE));
            }
        }
    }
}

