/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.client.integration.jei;

import java.util.Collections;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.tags.ITag;
import tcintegrations.data.integration.ModIntegration;
import tcintegrations.data.tcon.SmelteryCompat;
import tcintegrations.items.TCIntegrationsItems;
import tcintegrations.util.ResourceLocationHelper;
import tcintegrations.util.TagHelper;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocationHelper.resource("jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IIngredientManager manager = jeiRuntime.getIngredientManager();
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            ITag<Item> ingot = TagHelper.getTag(ResourceLocationHelper.location("forge", "ingots/" + compat.getName()));
            if (!ingot.isEmpty()) continue;
            try {
                JEIPlugin.removeFluid(manager, compat.getFluid().get(), compat.getBucket());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (!ModIntegration.canLoad("botania")) {
            JEIPlugin.removeFluid(manager, TCIntegrationsItems.MOLTEN_MANASTEEL.get(), TCIntegrationsItems.MOLTEN_MANASTEEL.getBucket());
        }
        if (!ModIntegration.canLoad("aquaculture")) {
            JEIPlugin.removeFluid(manager, TCIntegrationsItems.MOLTEN_NEPTUNIUM.get(), TCIntegrationsItems.MOLTEN_NEPTUNIUM.getBucket());
        }
        if (!ModIntegration.canLoad("malum")) {
            JEIPlugin.removeFluid(manager, TCIntegrationsItems.MOLTEN_SOUL_STAINED_STEEL.get(), TCIntegrationsItems.MOLTEN_SOUL_STAINED_STEEL.getBucket());
        }
        if (!ModIntegration.canLoad("undergarden")) {
            JEIPlugin.removeFluid(manager, TCIntegrationsItems.MOLTEN_CLOGGRUM.get(), TCIntegrationsItems.MOLTEN_CLOGGRUM.getBucket());
            JEIPlugin.removeFluid(manager, TCIntegrationsItems.MOLTEN_FROSTSTEEL.get(), TCIntegrationsItems.MOLTEN_FROSTSTEEL.getBucket());
            JEIPlugin.removeFluid(manager, TCIntegrationsItems.MOLTEN_FORGOTTEN_METAL.get(), TCIntegrationsItems.MOLTEN_FORGOTTEN_METAL.getBucket());
        }
        if (!ModIntegration.canLoad("iceandfire")) {
            JEIPlugin.removeFluid(manager, TCIntegrationsItems.MOLTEN_DRAGONSTEEL_FIRE.get(), TCIntegrationsItems.MOLTEN_DRAGONSTEEL_FIRE.getBucket());
            JEIPlugin.removeFluid(manager, TCIntegrationsItems.MOLTEN_DRAGONSTEEL_ICE.get(), TCIntegrationsItems.MOLTEN_DRAGONSTEEL_ICE.getBucket());
            JEIPlugin.removeFluid(manager, TCIntegrationsItems.MOLTEN_DRAGONSTEEL_LIGHTNING.get(), TCIntegrationsItems.MOLTEN_DRAGONSTEEL_LIGHTNING.getBucket());
        }
        if (!ModIntegration.canLoad("ars_nouveau")) {
            JEIPlugin.removeFluid(manager, TCIntegrationsItems.MOLTEN_SOURCE_GEM.get(), TCIntegrationsItems.MOLTEN_SOURCE_GEM.getBucket());
        }
    }

    private static void removeFluid(IIngredientManager manager, Fluid fluid, Item bucket) {
        manager.removeIngredientsAtRuntime((IIngredientType)ForgeTypes.FLUID_STACK, Collections.singleton(new FluidStack(fluid, 1000)));
        manager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)bucket)));
    }
}

