/*
 * Decompiled with CFR 0.152.
 */
package net.reversteam.perdition.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.reversteam.perdition.entity.RiftEntity;
import org.joml.Matrix4f;

public class RiftRenderer
extends EntityRenderer<RiftEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("perdition:textures/entities/purgatory_rift.png");
    private static final int TOTAL_FRAMES = 20;
    private static final int FRAME_HEIGHT_PIXELS = 128;
    private static final int TOTAL_TEXTURE_HEIGHT = 2560;
    private static final float TICKS_PER_FRAME = 2.0f;
    private static final float WIDTH = 0.5f;
    private static final float JITTER_AMOUNT = 0.05f;

    public RiftRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.0f;
    }

    public void render(RiftEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)entity.m_20206_() * 0.5, 0.0);
        float jitterX = (float)((Math.random() - 0.5) * 2.0 * (double)0.05f);
        float jitterY = (float)((Math.random() - 0.5) * 2.0 * (double)0.05f);
        poseStack.m_85837_((double)jitterX, (double)jitterY, 0.0);
        Vec3 camPos = this.f_114476_.f_114358_.m_90583_();
        double dx = camPos.f_82479_ - entity.m_20185_();
        double dz = camPos.f_82481_ - entity.m_20189_();
        float yaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(yaw));
        float height = 1.0f;
        poseStack.m_85841_(1.5f, 1.5f, 1.5f);
        float frameVHeight = 0.05f;
        int frameIndex = (int)((float)entity.f_19797_ / 2.0f % 20.0f);
        float v0 = (float)frameIndex * frameVHeight;
        float v1 = v0 + frameVHeight;
        VertexConsumer vc = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE));
        int overlay = OverlayTexture.f_118083_;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        vc.m_252986_(matrix, -0.5f, -height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, v1).m_86008_(overlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vc.m_252986_(matrix, 0.5f, -height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, v1).m_86008_(overlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vc.m_252986_(matrix, 0.5f, height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, v0).m_86008_(overlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vc.m_252986_(matrix, -0.5f, height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, v0).m_86008_(overlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(RiftEntity entity) {
        return TEXTURE;
    }
}

