/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.impl.client;

import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.util.RenderHelper;
import net.darkhax.tipsmod.api.TipsAPI;
import net.darkhax.tipsmod.api.resources.ITip;
import net.darkhax.tipsmod.impl.TipsModCommon;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class TipRenderHandler {
    private static long initTime = System.currentTimeMillis();
    @Nullable
    private static ITip tip;
    @Nullable
    private static WeakReference<Screen> lastScreen;

    private static void setTip(ITip newTip) {
        if (newTip == TipsAPI.EMPTY) {
            newTip = null;
        }
        tip = newTip;
        initTime = System.currentTimeMillis();
    }

    public static void drawTip(GuiGraphics graphics, Screen parentScreen) {
        if (!(tip != null || lastScreen != null && lastScreen.refersTo(parentScreen))) {
            TipRenderHandler.setTip(TipsAPI.getRandomTip(parentScreen));
            lastScreen = new WeakReference<Screen>(parentScreen);
        }
        if (tip != null) {
            int currentCycleTime;
            long currentTime = System.currentTimeMillis();
            if (currentTime - initTime > (long)(currentCycleTime = tip.getCycleTime())) {
                TipRenderHandler.setTip(TipsAPI.getRandomTip(parentScreen));
            }
            if (tip != null && tip.canDisplayOnScreen(parentScreen)) {
                int textWidth = Mth.m_14143_((float)((float)parentScreen.f_96543_ * TipsModCommon.CONFIG.tipRenderWidthPercent));
                int height = parentScreen.f_96544_ - 10;
                height -= RenderHelper.renderLinesReversed((GuiGraphics)graphics, (int)10, (int)height, (FormattedText)tip.getText(), (int)textWidth);
                RenderHelper.renderLinesReversed((GuiGraphics)graphics, (int)10, (int)(height -= 3), (FormattedText)tip.getTitle(), (int)textWidth);
            }
        }
    }
}

