/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_enchanting;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import fzzyhmstrs.emi_enchanting.EmiEnchanting;
import fzzyhmstrs.emi_enchanting.EnchantmentRecipe;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public class EmiClientPlugin
implements EmiPlugin {
    private static final ResourceLocation ENCHANTING_ID = new ResourceLocation(EmiEnchanting.MOD_ID, "enchantments");
    public static final EmiRecipeCategory ENCHANTING_CATEGORY = new EmiRecipeCategory(ENCHANTING_ID, (EmiRenderable)EmiStack.of((ItemLike)Items.f_42690_));

    public void register(EmiRegistry registry) {
        registry.addCategory(ENCHANTING_CATEGORY);
        ArrayListMultimap enchantsMap = ArrayListMultimap.create();
        for (Enchantment enchantment : BuiltInRegistries.f_256876_) {
            for (int i = 1; i <= enchantment.m_6586_(); ++i) {
                enchantsMap.put((Object)enchantment, (Object)EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, i)));
            }
        }
        ImmutableMap enchantsMapAsMap = ImmutableMap.copyOf((Map)enchantsMap.asMap());
        for (Map.Entry entry : enchantsMapAsMap.entrySet()) {
            registry.addRecipe((EmiRecipe)new EnchantmentRecipe((Collection)entry.getValue(), (Enchantment)entry.getKey(), (Map<Enchantment, Collection<ItemStack>>)enchantsMapAsMap));
        }
    }
}

