/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.registry;

import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.items.ModuleTier;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import dev.quarris.ppfluids.item.FluidExtractionModuleItem;
import dev.quarris.ppfluids.item.FluidFilterModuleItem;
import dev.quarris.ppfluids.item.FluidItem;
import dev.quarris.ppfluids.item.FluidRetrievalModuleItem;
import dev.quarris.ppfluids.pipenetwork.FluidPipeItem;
import dev.quarris.ppfluids.registry.BlockSetup;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ItemSetup {
    public static final DeferredRegister<Item> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"ppfluids");
    public static final RegistryObject<Item> FLUID_HOLDER = REGISTRY.register("fluid_item", FluidItem::new);

    public static void init(IEventBus bus) {
        REGISTRY.register(bus);
    }

    private static void registerTieredModule(DeferredRegister<Item> registry, String name, BiFunction<String, ModuleTier, ModuleItem> item) {
        for (ModuleTier tier : ModuleTier.values()) {
            String moduleName = tier.name().toLowerCase(Locale.ROOT) + "_" + name;
            registry.register(moduleName, () -> (ModuleItem)item.apply(name, tier));
        }
    }

    static {
        REGISTRY.register(BlockSetup.FLUID_PIPE.getId().m_135815_(), () -> new BlockItem((Block)BlockSetup.FLUID_PIPE.get(), new Item.Properties()));
        ItemSetup.registerTieredModule(REGISTRY, "fluid_extraction_module", FluidExtractionModuleItem::new);
        ItemSetup.registerTieredModule(REGISTRY, "fluid_filter_module", FluidFilterModuleItem::new);
        ItemSetup.registerTieredModule(REGISTRY, "fluid_retrieval_module", FluidRetrievalModuleItem::new);
        IPipeItem.TYPES.put(FluidPipeItem.FLUID_TYPE, FluidPipeItem::new);
    }
}

