/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.pipenetwork;

import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import dev.quarris.ppfluids.item.FluidItem;
import dev.quarris.ppfluids.pipe.FluidPipeBlockEntity;
import dev.quarris.ppfluids.pipenetwork.FluidNetworkLocation;
import dev.quarris.ppfluids.pipenetwork.FluidPipeItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;

public class PipeNetworkUtil {
    public static FluidStack routeFluid(Level level, BlockPos inputPipePos, BlockPos inputTankPos, FluidStack fluid, BiFunction<ItemStack, Float, FluidPipeItem> itemSupplier, boolean preventOversending) {
        PipeNetwork network = PipeNetwork.get((Level)level);
        if (!network.isNode(inputPipePos)) {
            return fluid;
        }
        if (!level.m_46749_(inputPipePos)) {
            return fluid;
        }
        PipeBlockEntity inputPipe = network.getPipe(inputPipePos);
        if (inputPipe == null) {
            return fluid;
        }
        network.startProfile("find_fluid_destination");
        List nodes = network.getOrderedNetworkNodes(inputPipePos).stream().filter(arg_0 -> ((Level)level).m_46749_(arg_0)).filter(pos -> level.m_7702_(pos) instanceof FluidPipeBlockEntity).collect(Collectors.toList());
        for (int i = 0; i < nodes.size(); ++i) {
            FluidPipeBlockEntity pipe;
            Pair<BlockPos, ItemStack> dest;
            BlockPos pipePos = (BlockPos)nodes.get(inputPipe.getNextNode(nodes, i));
            if (!level.m_46749_(pipePos) || (dest = (pipe = (FluidPipeBlockEntity)network.getPipe(pipePos)).getAvailableDestination(Direction.values(), fluid.copy(), false, preventOversending)) == null || ((BlockPos)dest.getLeft()).equals((Object)inputTankPos)) continue;
            Function<Float, IPipeItem> sup = speed -> (IPipeItem)itemSupplier.apply((ItemStack)dest.getRight(), (Float)speed);
            if (!network.routeItemToLocation(inputPipePos, inputTankPos, pipe.m_58899_(), (BlockPos)dest.getLeft(), (ItemStack)dest.getRight(), sup)) continue;
            FluidStack remain = fluid.copy();
            FluidStack routedFluid = FluidItem.getFluidCopyFromItem((ItemStack)dest.getRight());
            remain.shrink(routedFluid.getAmount());
            network.endProfile();
            return remain;
        }
        network.endProfile();
        return fluid;
    }

    public static FluidStack requestFluid(Level level, BlockPos destPipe, BlockPos destInventory, FluidStack fluid) {
        PipeNetwork network = PipeNetwork.get((Level)level);
        FluidStack remain = fluid.copy();
        for (FluidNetworkLocation location : PipeNetworkUtil.getOrderedNetworkFluids(level, destPipe)) {
            remain = PipeNetworkUtil.requestExistingFluid(level, location, destPipe, destInventory, null, remain);
            if (!remain.isEmpty()) continue;
            return remain;
        }
        return FluidStack.EMPTY;
    }

    public static FluidStack requestExistingFluid(Level level, FluidNetworkLocation location, BlockPos destPipe, BlockPos destInventory, NetworkLock ignoredLock, FluidStack fluid) {
        PipeNetwork network = PipeNetwork.get((Level)level);
        if (location.getPos().equals((Object)destInventory)) {
            return fluid;
        }
        int amount = location.getFluidAmount(level, fluid);
        if (amount <= 0) {
            return fluid;
        }
        FluidStack remain = fluid.copy();
        if (remain.getAmount() < amount) {
            amount = remain.getAmount();
        }
        remain.shrink(amount);
        for (int slot : location.getFluidSlots(level, fluid)) {
            IFluidHandler handler = location.getFluidHandler(level);
            FluidStack stack = handler.getFluidInTank(slot).copy();
            FluidStack extracted = handler.drain(stack, IFluidHandler.FluidAction.SIMULATE);
            ItemStack fluidItem = FluidItem.createItemFromFluid(extracted, false);
            if (!network.routeItemToLocation(location.pipePos, location.getPos(), destPipe, destInventory, fluidItem, speed -> new FluidPipeItem(fluidItem, speed.floatValue()))) continue;
            handler.drain(extracted, IFluidHandler.FluidAction.EXECUTE);
            if ((amount -= extracted.getAmount()) > 0) continue;
            break;
        }
        return remain;
    }

    public static List<FluidNetworkLocation> getOrderedNetworkFluids(Level level, BlockPos node) {
        PipeNetwork network = PipeNetwork.get((Level)level);
        if (!network.isNode(node)) {
            return Collections.emptyList();
        }
        network.startProfile("get_network_fluids");
        ArrayList<FluidNetworkLocation> info = new ArrayList<FluidNetworkLocation>();
        for (BlockPos dest : network.getOrderedNetworkNodes(node)) {
            PipeBlockEntity block;
            if (!level.m_46749_(dest) || !((block = network.getPipe(dest)) instanceof FluidPipeBlockEntity)) continue;
            FluidPipeBlockEntity pipe = (FluidPipeBlockEntity)block;
            for (Direction dir : Direction.values()) {
                FluidNetworkLocation location;
                IFluidHandler handler = pipe.getFluidHandler(dir);
                if (handler == null || !pipe.canNetworkSee(dir, handler) || info.stream().anyMatch(l -> handler.equals(l.getFluidHandler(level))) || (location = new FluidNetworkLocation(dest, dir)).isEmpty(level)) continue;
                info.add(location);
            }
        }
        network.endProfile();
        return info;
    }
}

