/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.pipe;

import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import dev.quarris.ppfluids.item.FluidItem;
import dev.quarris.ppfluids.item.IFluidFilterProvider;
import dev.quarris.ppfluids.item.IFluidModule;
import dev.quarris.ppfluids.misc.FluidFilter;
import dev.quarris.ppfluids.pipenetwork.FluidPipeItem;
import dev.quarris.ppfluids.registry.BlockEntitySetup;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class FluidPipeBlockEntity
extends PipeBlockEntity {
    public FluidPipeBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
        this.f_58855_ = (BlockEntityType)BlockEntitySetup.FLUID_PIPE.get();
    }

    public Pair<BlockPos, ItemStack> getAvailableDestinationOrConnectable(ItemStack stack, boolean force, boolean preventOversending) {
        return super.getAvailableDestinationOrConnectable(stack, force, preventOversending);
    }

    public Pair<BlockPos, ItemStack> getAvailableDestination(Direction[] directions, ItemStack stack, boolean force, boolean preventOversending) {
        return super.getAvailableDestination(directions, stack, force, preventOversending);
    }

    public Pair<BlockPos, ItemStack> getAvailableDestination(Direction[] directions, FluidStack fluid, boolean force, boolean preventOversending) {
        if (!this.canWork()) {
            return null;
        }
        for (Direction dir : directions) {
            PipeNetwork network;
            int onTheWay;
            int amountFilled;
            IFluidHandler tank = this.getFluidHandler(dir);
            if (tank == null || !force && this.streamModules().filter(m -> m.getRight() instanceof IFluidModule).anyMatch(m -> !((IFluidModule)m.getRight()).canAcceptItem((ItemStack)m.getLeft(), (PipeBlockEntity)this, FluidItem.createItemFromFluid(fluid, false), dir, tank)) || (amountFilled = tank.fill(fluid, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
            FluidStack toInsert = fluid.copy();
            toInsert.setAmount(amountFilled);
            int maxAmount = Integer.MAX_VALUE;
            if (maxAmount < toInsert.getAmount()) {
                toInsert.setAmount(maxAmount);
            }
            BlockPos tankPos = this.m_58899_().m_121945_(dir);
            if ((preventOversending || maxAmount < Integer.MAX_VALUE) && (onTheWay = (network = PipeNetwork.get((Level)this.f_58857_)).getPipeItemsOnTheWay(tankPos).filter(item -> item instanceof FluidPipeItem).map(item -> (FluidPipeItem)((Object)item)).filter(item -> toInsert.getFluid().m_6212_(item.getFluidContent().getFluid())).mapToInt(item -> item.getFluidContent().getAmount()).sum()) > 0) {
                FluidStack copy = toInsert.copy();
                copy.setAmount(Integer.MAX_VALUE);
                int availableSpace = tank.fill(copy, IFluidHandler.FluidAction.SIMULATE);
                if (onTheWay + toInsert.getAmount() > availableSpace) {
                    toInsert.setAmount(availableSpace - onTheWay);
                }
            }
            if (toInsert.isEmpty()) continue;
            return Pair.of((Object)tankPos, (Object)FluidItem.createItemFromFluid(toInsert, false));
        }
        return null;
    }

    public boolean canNetworkSee(Direction direction, IItemHandler handler) {
        return false;
    }

    public boolean canNetworkSee(Direction direction, IFluidHandler handler) {
        return this.streamModules().filter(m -> m.getRight() instanceof IFluidModule).allMatch(m -> ((IFluidModule)m.getRight()).canNetworkSee((ItemStack)m.getLeft(), (PipeBlockEntity)this, direction, handler));
    }

    public boolean canHaveModules() {
        for (Direction dir : Direction.values()) {
            if (this.getFluidHandler(dir) != null) {
                return true;
            }
            IPipeConnectable connectable = this.getPipeConnectable(dir);
            if (connectable == null || !connectable.allowsModules(this.f_58858_, dir)) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected(Direction dir) {
        return super.isConnected(dir);
    }

    public IFluidHandler getFluidHandler(Direction dir) {
        IFluidHandler handler;
        if (!this.isConnected(dir)) {
            return null;
        }
        BlockPos pos = this.m_58899_().m_121945_(dir);
        BlockEntity tile = this.f_58857_.m_7702_(pos);
        if (tile != null && (handler = (IFluidHandler)tile.getCapability(ForgeCapabilities.FLUID_HANDLER, dir.m_122424_()).orElse(null)) != null) {
            return handler;
        }
        return null;
    }

    public IItemHandler getItemHandler(Direction dir) {
        IFluidHandler fluidHandler = this.getFluidHandler(dir);
        if (fluidHandler != null) {
            // empty if block
        }
        return null;
    }

    public List<FluidFilter> getFluidFilters() {
        return this.streamModules().filter(p -> p.getRight() instanceof IFluidFilterProvider).map(p -> ((IFluidFilterProvider)p.getRight()).getFluidFilter((ItemStack)p.getLeft(), this)).collect(Collectors.toList());
    }
}

