/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.quarris.ppfluids.pipenetwork.FluidPipeItem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class FluidBlobRenderer {
    private static final FluidBlobModel MODEL = new FluidBlobModel(FluidBlobModel.createBlobLayer().m_171564_());

    public static void render(FluidPipeItem item, PoseStack matrix, Random random, float partialTicks, int light, int overlay, MultiBufferSource buffer) {
        long time = item.getTicksExisted();
        float lastSizeOffset = (float)(Math.sin(Math.toRadians((time - 1L) * 10L)) + 1.0) / 30.0f;
        float thisSizeOffset = (float)(Math.sin(Math.toRadians(time * 10L)) + 1.0) / 30.0f;
        float sizeOffset = Mth.m_14179_((float)partialTicks, (float)lastSizeOffset, (float)thisSizeOffset);
        FluidStack fluidStack = item.getFluidContent();
        Fluid fluid = fluidStack.getFluid();
        FluidState renderState = fluid.m_76145_();
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((FluidState)renderState);
        float size = Mth.m_14179_((float)Math.min(1.0f, (float)fluidStack.getAmount() / 2000.0f), (float)(0.1f - sizeOffset), (float)(0.25f + sizeOffset));
        int color = attributes.getTintColor(renderState, (BlockAndTintGetter)Minecraft.m_91087_().f_91073_, item.getCurrentPipe());
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color >> 0 & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float tx = Mth.m_14179_((float)partialTicks, (float)item.lastX, (float)item.x);
        float ty = Mth.m_14179_((float)partialTicks, (float)item.lastY, (float)item.y);
        float tz = Mth.m_14179_((float)partialTicks, (float)item.lastZ, (float)item.z);
        TextureAtlasSprite sprite = FluidBlobRenderer.getFluidStillSprite(fluid);
        VertexConsumer vbuf = sprite.m_118381_(buffer.m_6299_(RenderType.m_110473_((ResourceLocation)sprite.m_247685_())));
        matrix.m_85836_();
        matrix.m_252880_(tx, ty, tz);
        matrix.m_85841_(size, size, size);
        MODEL.m_7695_(matrix, vbuf, light, overlay, r, g, b, a);
        matrix.m_85849_();
    }

    private static TextureAtlasSprite getFluidStillSprite(Fluid fluid) {
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid);
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(attributes.getStillTexture());
    }

    public static class FluidBlobModel
    extends Model {
        private ModelPart blob;

        public FluidBlobModel(ModelPart root) {
            super(RenderType::m_110473_);
            this.blob = root.m_171324_("blob");
        }

        public static LayerDefinition createBlobLayer() {
            MeshDefinition mesh = new MeshDefinition();
            mesh.m_171576_().m_171599_("blob", CubeListBuilder.m_171558_().m_171481_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.f_171404_);
            return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
        }

        public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            this.blob.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }
}

