/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.oneenoughfluid.mixin;

import com.flechazo.oneenoughfluid.init.FluidReplacementCache;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.init.config.DomainConfig;
import com.mafuyu404.oneenoughitem.init.config.OEIConfig;
import com.mafuyu404.oneenoughitem.util.MixinUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagLoader;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TagLoader.class})
public abstract class TagLoaderMixin<T> {
    @Shadow
    @Final
    private String f_13449_;
    private static final String FLUIDS_TAG_DIR = "tags/fluids";

    @Inject(method={"load(Lnet/minecraft/server/packs/resources/ResourceManager;)Ljava/util/Map;"}, at={@At(value="RETURN")})
    private void oneenoughfluid$processTags(ResourceManager resourceManager, CallbackInfoReturnable<Map<ResourceLocation, List<TagLoader.EntryWithSource>>> cir) {
        if (!FLUIDS_TAG_DIR.equals(this.f_13449_)) {
            return;
        }
        Map tags = (Map)cir.getReturnValue();
        if (tags == null || tags.isEmpty()) {
            return;
        }
        MixinUtils.ReplacementLoader.CurrentSnapshot snap = MixinUtils.ReplacementLoader.loadCurrentSnapshot((ResourceManager)resourceManager);
        Map currentMap = snap.dataMap();
        Map currentRules = snap.dataRules();
        boolean fallbackEnabled = currentMap.isEmpty();
        Replacements.Rules defaultRules = null;
        try {
            DomainConfig.DefaultRules dr = OEIConfig.getDefaultRules((String)"oef");
            if (dr != null) {
                defaultRules = dr.toRules();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Map.Entry tagEntry : tags.entrySet()) {
            List entries = (List)tagEntry.getValue();
            if (entries == null || entries.isEmpty()) continue;
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                Replacements.Rules rules;
                boolean shouldReplace;
                TagLoader.EntryWithSource tracked = (TagLoader.EntryWithSource)it.next();
                TagEntry e = tracked.f_216042_();
                if (e.isTag()) continue;
                ResourceLocation fromId = e.getId();
                String fromStr = fromId.toString();
                String mapped = (String)currentMap.get(fromStr);
                if (mapped == null && fallbackEnabled) {
                    mapped = FluidReplacementCache.matchFluid(fromStr);
                }
                if (mapped == null || !(shouldReplace = (rules = currentRules.getOrDefault(fromStr, defaultRules)) != null && rules.tag().map(m -> (Replacements.ProcessingMode)m.get("fluids")).map(mode -> mode == Replacements.ProcessingMode.REPLACE).orElse(fallbackEnabled && FluidReplacementCache.shouldReplaceInTagType(fromStr, "fluids")) != false)) continue;
                it.remove();
            }
        }
    }
}

