/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.oneenoughfluid.init;

import com.flechazo.oneenoughfluid.init.FluidReplacementCache;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.init.AbstractReplacementStrategy;
import com.mafuyu404.oneenoughitem.util.MixinUtils;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class OEFReplacementStrategy
extends AbstractReplacementStrategy {
    public void replaceIdCommon(String id, MixinUtils.ReplaceContext ctx, BiConsumer<String, String> logReplaceAction, Consumer<JsonElement> setValueAction) {
        String target = this.resolveTarget(id, ctx);
        if (target == null) {
            return;
        }
        boolean shouldProcess = false;
        if (ctx.dataRules != null) {
            Replacements.Rules rules = (Replacements.Rules)ctx.dataRules.get(id);
            if (rules != null) {
                shouldProcess = rules.data().map(m -> (Replacements.ProcessingMode)m.get(ctx.dataType)).map(mode -> mode == Replacements.ProcessingMode.REPLACE).orElse(false);
            } else if (ctx.allowCacheFallback) {
                shouldProcess = FluidReplacementCache.shouldReplaceInDataDir(id, ctx.dataType);
            }
        } else if (ctx.allowCacheFallback) {
            shouldProcess = FluidReplacementCache.shouldReplaceInDataDir(id, ctx.dataType);
        }
        if (!shouldProcess) {
            return;
        }
        if ("minecraft:empty".equals(target)) {
            ctx.shouldDrop = true;
            MixinUtils.LogHelper.logDrop((String)ctx.dataType, (String)id, (String)target, (String)ctx.lastMappingOrigin, (String)"mapping");
            return;
        }
        if (!target.equals(id)) {
            setValueAction.accept((JsonElement)new JsonPrimitive(target));
            ctx.mutated = true;
            logReplaceAction.accept(id, target);
        }
        if (ctx.rule.strict() && this.isSourceIdWithCurrent(id, ctx)) {
            ctx.shouldDrop = true;
            MixinUtils.LogHelper.logDrop((String)ctx.dataType, (String)id, (String)ctx.lastMappingOrigin, (String)ctx.lastMappingOrigin, (String)"strict residual source-id");
        }
    }

    public MixinUtils.ReplacementLoader.CurrentSnapshot loadCurrentSnapshot(ResourceManager resourceManager) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, Replacements.Rules> fluidRules = new HashMap<String, Replacements.Rules>();
        HashMap<String, Replacements.Rules> tagRules = new HashMap<String, Replacements.Rules>();
        Predicate<ResourceLocation> jsonPredicate = rl -> rl.m_135815_().endsWith(".json") && "oef".equals(rl.m_135827_());
        for (String baseDir : REPLACEMENT_DIR_CANDIDATES) {
            try {
                Map res = resourceManager.m_214159_(baseDir, jsonPredicate);
                if (res.isEmpty()) continue;
                for (Map.Entry e : res.entrySet()) {
                    try {
                        BufferedReader reader = ((Resource)e.getValue()).m_215508_();
                        try {
                            JsonElement root = JsonParser.parseReader((Reader)reader);
                            this.parseReplacementJson(root, map, fluidRules, tagRules);
                        }
                        finally {
                            if (reader == null) continue;
                            ((Reader)reader).close();
                        }
                    }
                    catch (Exception ex) {
                        MixinUtils.LogHelper.logParseError((ResourceLocation)((ResourceLocation)e.getKey()), (Exception)ex);
                    }
                }
            }
            catch (Exception exception) {
            }
        }
        return new MixinUtils.ReplacementLoader.CurrentSnapshot(map, fluidRules, tagRules);
    }

    public String resolveTarget(String id, MixinUtils.ReplaceContext ctx) {
        String v;
        if (ctx.dataMap != null && (v = (String)ctx.dataMap.get(id)) != null) {
            ctx.lastMappingOrigin = "CURRENT";
            return v;
        }
        if (ctx.allowCacheFallback && (v = FluidReplacementCache.matchFluid(id)) != null) {
            ctx.lastMappingOrigin = "CACHE";
            return v;
        }
        ctx.lastMappingOrigin = "N/A";
        return null;
    }

    public boolean isSourceIdWithCurrent(String id, MixinUtils.ReplaceContext ctx) {
        if (ctx.sourceDataIds != null && ctx.sourceDataIds.contains(id)) {
            return true;
        }
        return ctx.allowCacheFallback && FluidReplacementCache.isSourceFluidId(id);
    }

    public void parseReplacementJson(JsonElement root, Map<String, String> outMap, Map<String, Replacements.Rules> outDataRules, Map<String, Replacements.Rules> outTagRules) {
        JsonObject obj;
        if (root == null) {
            return;
        }
        if (root.isJsonObject() && (obj = root.getAsJsonObject()).has("matchFluid") && obj.get("matchFluid").isJsonArray() && obj.has("resultFluid")) {
            String result = obj.get("resultFluid").getAsString();
            obj.getAsJsonArray("matchFluid").forEach(el -> {
                if (el.isJsonPrimitive() && el.getAsJsonPrimitive().isString()) {
                    outMap.put(el.getAsString(), result);
                }
            });
        }
    }

    public MixinUtils.FieldRule getDataDirFieldRule(String directory) {
        return switch (directory) {
            case "recipes" -> new MixinUtils.FieldRule(Set.of("fluid", "id", "result", "result_fluid"), true);
            case "advancements" -> new MixinUtils.FieldRule(Set.of("fluid", "result_fluid"), true);
            case "loot_tables" -> new MixinUtils.FieldRule(Set.of("name", "result_fluid", "fluid"), true);
            default -> new MixinUtils.FieldRule(Set.of("fluid", "id", "result", "result_fluid"), false);
        };
    }
}

