/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.oneenoughfluid.data;

import com.flechazo.oneenoughfluid.init.Utils;
import com.mafuyu404.oneenoughitem.data.BaseReplacementValidator;
import com.mafuyu404.oneenoughitem.data.ValidationStreams;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;

public class FluidReplacementValidator
extends BaseReplacementValidator {
    protected boolean isResultExists(String resultId) {
        Fluid f = Utils.getFluidById(resultId);
        return f != null;
    }

    protected ValidationStreams.Accumulator fromDomainObject(String id, ResourceLocation source) {
        return Utils.getFluidById(id) != null ? ValidationStreams.Accumulator.valid((int)1) : ValidationStreams.Accumulator.invalid();
    }

    protected ValidationStreams.Accumulator fromDomainTag(String tagId, ResourceLocation source) {
        try {
            ResourceLocation tag = new ResourceLocation(tagId);
            if (Utils.isTagExists(tag)) {
                Collection<Fluid> objs = Utils.getFluidsOfTag(tag);
                return !objs.isEmpty() ? ValidationStreams.Accumulator.valid((int)objs.size()) : ValidationStreams.Accumulator.invalid();
            }
            return ValidationStreams.Accumulator.deferred();
        }
        catch (Exception e) {
            return ValidationStreams.Accumulator.failure((String)("Invalid tag format: " + tagId));
        }
    }
}

