/*
 * Decompiled with CFR 0.152.
 */
package io.me.exposed;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.me.storage.NetworkStorage;
import io.me.exposed.MExposedConfig;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ExposedInvHandler
implements IItemHandler,
IFluidHandler {
    NetworkStorage storage;

    public ExposedInvHandler(NetworkStorage storage) {
        this.storage = storage;
    }

    List<AEFluidKey> getFluidKeys() {
        return this.storage.getAvailableStacks().keySet().stream().filter(aeKey -> aeKey instanceof AEFluidKey).map(aeKey -> (AEFluidKey)aeKey).toList();
    }

    List<AEItemKey> getItemKeys() {
        return this.storage.getAvailableStacks().keySet().stream().filter(aeKey -> aeKey instanceof AEItemKey).map(aeKey -> (AEItemKey)aeKey).toList();
    }

    public int getTanks() {
        return this.getFluidKeys().size();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        if (tank >= this.getFluidKeys().size()) {
            return FluidStack.EMPTY;
        }
        return this.getFluidKeys().get(tank).toStack((int)this.storage.extract((AEKey)this.getFluidKeys().get(tank), Integer.MAX_VALUE, Actionable.SIMULATE, IActionSource.empty()));
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack fluidStack) {
        return this.storage.insert((AEKey)AEFluidKey.of((FluidStack)fluidStack), (long)fluidStack.getAmount(), Actionable.SIMULATE, IActionSource.empty()) > 0L;
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        if (((Boolean)MExposedConfig.COMMON.readOnly.get()).booleanValue()) {
            return 0;
        }
        return (int)this.storage.insert((AEKey)AEFluidKey.of((FluidStack)fluidStack), (long)fluidStack.getAmount(), fluidAction == IFluidHandler.FluidAction.EXECUTE ? Actionable.MODULATE : Actionable.SIMULATE, IActionSource.empty());
    }

    @NotNull
    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        FluidStack copy = fluidStack.copy();
        if (copy.getFluid() instanceof EmptyFluid) {
            return FluidStack.EMPTY;
        }
        copy.setAmount((int)this.storage.extract((AEKey)AEFluidKey.of((FluidStack)fluidStack), (long)fluidStack.getAmount(), fluidAction == IFluidHandler.FluidAction.EXECUTE ? Actionable.MODULATE : Actionable.SIMULATE, IActionSource.empty()));
        return copy.getAmount() > 0 ? copy : FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int amount, IFluidHandler.FluidAction fluidAction) {
        return this.drain(this.getFluidInTank(0), fluidAction);
    }

    public int getSlots() {
        return this.getItemKeys().size() + 16;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot >= this.getItemKeys().size()) {
            return ItemStack.f_41583_;
        }
        return this.getItemKeys().get(slot).toStack((int)this.storage.extract((AEKey)this.getItemKeys().get(slot), Integer.MAX_VALUE, Actionable.SIMULATE, IActionSource.empty()));
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack copy = stack.m_41777_();
        if (((Boolean)MExposedConfig.COMMON.readOnly.get()).booleanValue()) {
            return copy;
        }
        copy.m_41764_(copy.m_41613_() - (int)this.storage.insert((AEKey)AEItemKey.of((ItemStack)stack), (long)stack.m_41613_(), simulate ? Actionable.SIMULATE : Actionable.MODULATE, IActionSource.empty()));
        return copy;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack copy = this.getStackInSlot(slot).m_41777_();
        AEItemKey key = AEItemKey.of((ItemStack)copy);
        if (key == null) {
            return ItemStack.f_41583_;
        }
        copy.m_41764_((int)this.storage.extract((AEKey)key, (long)amount, simulate ? Actionable.SIMULATE : Actionable.MODULATE, IActionSource.empty()));
        return copy;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.insertItem(slot, stack, true).m_41613_() == 0;
    }
}

