/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.armors;

import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.pedroksl.advanced_ae.client.renderer.QuantumArmorRenderer;
import net.pedroksl.advanced_ae.common.definitions.AAEMaterials;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.helpers.PortableCellWorkbenchMenuHost;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.QuantumUpgradeBaseItem;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.network.packet.MenuSelectionPacket;
import net.pedroksl.advanced_ae.xmod.iris.IrisPlugin;
import org.jetbrains.annotations.Nullable;

public class QuantumHelmet
extends QuantumArmorBase {
    private static final double MAX_POWER_STORAGE = 2.0E8;

    public QuantumHelmet(Item.Properties properties) {
        super(AAEMaterials.QUANTUM_ALLOY, ArmorItem.Type.HELMET, properties, () -> 2.0E8);
        this.registerUpgrades(UpgradeType.WATER_BREATHING, UpgradeType.AUTO_FEED, UpgradeType.AUTO_STOCK, UpgradeType.MAGNET, UpgradeType.LUCK, UpgradeType.NIGHT_VISION, UpgradeType.CHARGING, UpgradeType.WORKBENCH);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (slotId == EquipmentSlot.HEAD.m_20749_() && entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.getPassiveUpgrades(stack).isEmpty()) {
                this.tickUpgrades(level, player, stack);
            }
            if (level.m_5776_()) {
                this.toggleBoneVisibilities(stack, player);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void toggleBoneVisibilities(ItemStack stack, Player player) {
        QuantumArmorBase item = (QuantumArmorBase)stack.m_41720_();
        HumanoidModel renderer = IClientItemExtensions.of((Item)item).getHumanoidArmorModel((LivingEntity)player, stack, EquipmentSlot.HEAD, null);
        if (renderer instanceof QuantumArmorRenderer) {
            QuantumArmorRenderer quantumRenderer = (QuantumArmorRenderer)renderer;
            boolean visible = IrisPlugin.isShaderPackInUse();
            quantumRenderer.setBoneVisible("hud", visible);
        }
    }

    @Override
    public boolean openFromEquipmentSlot(Player player, int inventorySlot, ItemStack stack, boolean returningFromSubmenu) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.checkPreconditions(stack)) {
                player.getPersistentData().m_128405_("aae$menutype", QuantumArmorBase.MenuId.STANDARD.id);
                AAENetworkHandler.INSTANCE.sendTo(new MenuSelectionPacket("aae$menutype", QuantumArmorBase.MenuId.STANDARD.id), serverPlayer);
            }
        }
        return super.openFromEquipmentSlot(player, inventorySlot, stack, returningFromSubmenu);
    }

    public boolean openPortableWorkbench(Player player, int inventorySlot, ItemStack stack) {
        return this.openPortableWorkbench(player, inventorySlot, stack, false);
    }

    public boolean openPortableWorkbench(Player player, int inventorySlot, ItemStack stack, boolean returningFromSubmenu) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.checkPreconditions(stack)) {
                if (((QuantumHelmet)stack.m_41720_()).isUpgradeEnabled(stack, UpgradeType.WORKBENCH)) {
                    player.getPersistentData().m_128405_("aae$menutype", QuantumArmorBase.MenuId.WORKBENCH.id);
                    AAENetworkHandler.INSTANCE.sendTo(new MenuSelectionPacket("aae$menutype", QuantumArmorBase.MenuId.WORKBENCH.id), serverPlayer);
                    return MenuOpener.open(AAEMenus.PORTABLE_WORKBENCH.get(), (Player)player, (MenuLocator)MenuLocators.forInventorySlot((int)inventorySlot), (boolean)returningFromSubmenu);
                }
                MutableComponent id = Component.m_237115_((String)((QuantumUpgradeBaseItem)UpgradeType.WORKBENCH.item().m_5456_()).m_5524_());
                player.m_5661_((Component)AAEText.UpgradeNotInstalledMessage.text(new Object[]{id}), true);
            }
        }
        return false;
    }

    @Override
    public ItemMenuHost getMenuHost(Player player, int inventorySlot, ItemStack stack, @Nullable BlockPos pos) {
        if (player.getPersistentData().m_128441_("aae$menutype") && player.getPersistentData().m_128451_("aae$menutype") == QuantumArmorBase.MenuId.WORKBENCH.id) {
            player.getPersistentData().m_128473_("aae$menutype");
            return new PortableCellWorkbenchMenuHost(player, inventorySlot, stack);
        }
        player.getPersistentData().m_128473_("aae$menutype");
        return super.getMenuHost(player, inventorySlot, stack, pos);
    }
}

