/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.helpers;

import java.awt.Color;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class AAEColor {
    public static final AAEColor WHITE = AAEColor.ofArgb(-1);
    public static final AAEColor LIGHT_GRAY = AAEColor.ofArgb(-5394236);
    public static final AAEColor DARK_GRAY_BLUE = AAEColor.ofArgb(-12501164);
    public static final AAEColor LIGHT_PURPLE = AAEColor.ofArgb(2021479361);
    public static final AAEColor PURPLE = AAEColor.ofArgb(-9367387);
    public static final AAEColor DARK_GRAY = AAEColor.ofArgb(0x8B8B8B);
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;

    AAEColor(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    AAEColor(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public static AAEColor ofArgb(int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return new AAEColor(red, green, blue, alpha);
    }

    public static AAEColor ofRgb(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return new AAEColor(red, green, blue);
    }

    public static AAEColor ofHsv(float hue, float saturation, float value) {
        return AAEColor.ofRgb(Mth.m_14169_((float)(hue - 5.0E-8f), (float)saturation, (float)value));
    }

    public static AAEColor ofHsv(float hue, float saturation, float value, float alpha) {
        int color = Mth.m_14169_((float)(hue - 5.0E-8f), (float)saturation, (float)value);
        return AAEColor.ofArgb(color | 0xFF000000);
    }

    public float r() {
        return (float)this.red / 255.0f;
    }

    public float g() {
        return (float)this.green / 255.0f;
    }

    public float b() {
        return (float)this.blue / 255.0f;
    }

    public float a() {
        return (float)this.alpha / 255.0f;
    }

    public int argb() {
        return FastColor.ARGB32.m_13660_((int)this.alpha, (int)this.red, (int)this.green, (int)this.blue);
    }

    public int argb(int alpha) {
        return FastColor.ARGB32.m_13660_((int)alpha, (int)this.red, (int)this.green, (int)this.blue);
    }

    public int rgb() {
        return this.red << 16 | this.green << 8 | this.blue;
    }

    public HSV hsv() {
        float[] vals = new float[3];
        Color.RGBtoHSB(this.red, this.green, this.blue, vals);
        return new HSV(vals[0], vals[1], vals[2]);
    }

    public record HSV(float hue, float saturation, float value) {
    }
}

