/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client;

import appeng.api.util.AEColor;
import appeng.client.render.StaticItemColor;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import appeng.client.render.crafting.CraftingCubeModel;
import appeng.hooks.BuiltInModelHooks;
import appeng.init.client.InitScreens;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.client.AAEHotkeys;
import net.pedroksl.advanced_ae.client.gui.AdvPatternEncoderScreen;
import net.pedroksl.advanced_ae.client.gui.AdvPatternProviderScreen;
import net.pedroksl.advanced_ae.client.gui.AdvancedIOBusScreen;
import net.pedroksl.advanced_ae.client.gui.ImportExportBusScreen;
import net.pedroksl.advanced_ae.client.gui.PortableWorkbenchScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumArmorConfigScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumArmorFilterConfigScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumArmorMagnetScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumArmorNumInputConfigScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumArmorStyleConfigScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumComputerScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterConfigPatternScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterTermScreen;
import net.pedroksl.advanced_ae.client.gui.ReactionChamberScreen;
import net.pedroksl.advanced_ae.client.gui.SmallAdvPatternProviderScreen;
import net.pedroksl.advanced_ae.client.gui.StockExportBusScreen;
import net.pedroksl.advanced_ae.client.renderer.AAECraftingUnitModelProvider;
import net.pedroksl.advanced_ae.client.renderer.ReactionChamberTESR;
import net.pedroksl.advanced_ae.common.blocks.AAECraftingUnitType;
import net.pedroksl.advanced_ae.common.definitions.AAEBlockEntities;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.events.AAEClientPlayerEvents;
import net.pedroksl.advanced_ae.xmod.Addons;
import net.pedroksl.advanced_ae.xmod.ae2wtlib.AE2WtLibPlugin;
import net.pedroksl.ae2addonlib.registry.FluidRegistry;
import net.pedroksl.ae2addonlib.registry.helpers.FluidDefinition;
import net.pedroksl.ae2addonlib.registry.helpers.LibItemDefinition;
import net.pedroksl.ae2addonlib.registry.helpers.LibTags;
import net.pedroksl.ae2addonlib.util.Colors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyIn(value=Dist.CLIENT)
public class AAEClient
extends AdvancedAE {
    private static final Logger LOGGER = LoggerFactory.getLogger(AAEClient.class);
    private static AAEClient INSTANCE;

    public AAEClient() {
        AAEClient.initBuiltInModels();
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        AAEClientPlayerEvents.init();
        eventBus.addListener(AAEClient::initItemBlockRenderTypes);
        eventBus.addListener(AAEClient::initItemColours);
        eventBus.addListener(AAEClient::initRenderers);
        eventBus.addListener(this::registerHotkeys);
        INSTANCE = this;
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase == TickEvent.Phase.END) {
                AAEHotkeys.INSTANCE.checkHotkeys();
            }
        });
        eventBus.addListener(this::clientSetup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            try {
                AAEClient.initScreens();
            }
            catch (Throwable e) {
                LOGGER.error("AAE failed postClientSetup", e);
                throw new RuntimeException(e);
            }
        });
    }

    private static void initBuiltInModels() {
        for (AAECraftingUnitType type : AAECraftingUnitType.values()) {
            BuiltInModelHooks.addBuiltInModel((ResourceLocation)AdvancedAE.makeId("block/crafting/" + type.getAffix() + "_formed"), (UnbakedModel)new CraftingCubeModel((AbstractCraftingUnitModelProvider)new AAECraftingUnitModelProvider(type)));
        }
    }

    private static void initScreens() {
        InitScreens.register(AAEMenus.QUANTUM_COMPUTER.get(), QuantumComputerScreen::new, (String)"/screens/quantum_computer.json");
        InitScreens.register(AAEMenus.ADV_PATTERN_PROVIDER.get(), AdvPatternProviderScreen::new, (String)"/screens/adv_pattern_provider.json");
        InitScreens.register(AAEMenus.SMALL_ADV_PATTERN_PROVIDER.get(), SmallAdvPatternProviderScreen::new, (String)"/screens/small_adv_pattern_provider.json");
        InitScreens.register(AAEMenus.ADV_PATTERN_ENCODER.get(), AdvPatternEncoderScreen::new, (String)"/screens/adv_pattern_encoder.json");
        InitScreens.register(AAEMenus.REACTION_CHAMBER.get(), ReactionChamberScreen::new, (String)"/screens/reaction_chamber.json");
        InitScreens.register(AAEMenus.STOCK_EXPORT_BUS.get(), StockExportBusScreen::new, (String)"/screens/stock_export_bus.json");
        InitScreens.register(AAEMenus.IMPORT_EXPORT_BUS.get(), ImportExportBusScreen::new, (String)"/screens/import_export_bus.json");
        InitScreens.register(AAEMenus.ADVANCED_IO_BUS.get(), AdvancedIOBusScreen::new, (String)"/screens/advanced_io_bus.json");
        InitScreens.register(AAEMenus.QUANTUM_CRAFTER.get(), QuantumCrafterScreen::new, (String)"/screens/quantum_crafter.json");
        InitScreens.register(AAEMenus.CRAFTER_PATTERN_CONFIG.get(), QuantumCrafterConfigPatternScreen::new, (String)"/screens/quantum_crafter_pattern_config.json");
        InitScreens.register(AAEMenus.QUANTUM_CRAFTER_TERMINAL.get(), QuantumCrafterTermScreen::new, (String)"/screens/quantum_crafter_terminal.json");
        if (Addons.AE2WTLIB.isLoaded()) {
            AE2WtLibPlugin.initScreen();
        }
        InitScreens.register(AAEMenus.QUANTUM_ARMOR_CONFIG.get(), QuantumArmorConfigScreen::new, (String)"/screens/quantum_armor_config.json");
        InitScreens.register(AAEMenus.QUANTUM_ARMOR_NUM_INPUT.get(), QuantumArmorNumInputConfigScreen::new, (String)"/screens/quantum_armor_num_input_config.json");
        InitScreens.register(AAEMenus.QUANTUM_ARMOR_FILTER_CONFIG.get(), QuantumArmorFilterConfigScreen::new, (String)"/screens/quantum_armor_filter_config.json");
        InitScreens.register(AAEMenus.QUANTUM_ARMOR_MAGNET.get(), QuantumArmorMagnetScreen::new, (String)"/screens/quantum_armor_magnet.json");
        InitScreens.register(AAEMenus.QUANTUM_ARMOR_STYLE_CONFIG.get(), QuantumArmorStyleConfigScreen::new, (String)"/screens/quantum_armor_style.json");
        InitScreens.register(AAEMenus.PORTABLE_WORKBENCH.get(), PortableWorkbenchScreen::new, (String)"/screens/portable_workbench.json");
    }

    private static void initItemBlockRenderTypes(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Fluid)AAEFluids.QUANTUM_INFUSION.source(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)AAEFluids.QUANTUM_INFUSION.flowing(), (RenderType)RenderType.m_110466_());
        });
    }

    private void registerHotkeys(RegisterKeyMappingsEvent e) {
        AAEHotkeys.INSTANCE.finalizeRegistration(arg_0 -> ((RegisterKeyMappingsEvent)e).register(arg_0));
    }

    private static void initItemColours(RegisterColorHandlersEvent.Item event) {
        event.register(AAEClient.makeOpaque((ItemColor)new StaticItemColor(AEColor.TRANSPARENT)), new ItemLike[]{AAEItems.THROUGHPUT_MONITOR.m_5456_()});
        event.register(AAEClient.makeOpaque((ItemColor)new StaticItemColor(AEColor.TRANSPARENT)), new ItemLike[]{AAEItems.QUANTUM_CRAFTER_TERMINAL.m_5456_()});
        for (LibItemDefinition<?> item : AAEItems.getQuantumArmor()) {
            event.register((stack, index) -> index == 1 ? LibTags.getIntOrDefault((ItemStack)stack, (String)"tint_color", (int)Colors.PURPLE.argb()) : Colors.WHITE.argb(), new ItemLike[]{item});
        }
        for (FluidDefinition bucket : AAEFluids.INSTANCE.getFluids()) {
            event.getItemColors().m_92689_(FluidRegistry::getFluidColor, new ItemLike[]{bucket.bucketItem()});
        }
    }

    private static void initRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(AAEBlockEntities.REACTION_CHAMBER.get(), ReactionChamberTESR::new);
    }

    private static ItemColor makeOpaque(ItemColor itemColor) {
        return (stack, tintIndex) -> itemColor.m_92671_(stack, tintIndex) | 0xFF000000;
    }

    public static AAEClient instance() {
        return INSTANCE;
    }
}

