/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.common.gui;

import betteradvancements.common.gui.BetterAdvancementTab;
import betteradvancements.common.gui.BetterAdvancementTabType;
import betteradvancements.common.gui.BetterAdvancementWidget;
import betteradvancements.common.platform.Services;
import betteradvancements.common.reference.Resources;
import betteradvancements.common.util.RenderUtil;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket;
import net.minecraft.util.FormattedCharSequence;

public class BetterAdvancementsScreen
extends Screen
implements ClientAdvancements.Listener {
    private static final Component VERY_SAD_LABEL = Component.m_237115_((String)"advancements.sad_label");
    private static final Component NO_ADVANCEMENTS_LABEL = Component.m_237115_((String)"advancements.empty");
    private static final Component TITLE = Component.m_237115_((String)"gui.advancements");
    private static final int WIDTH = 252;
    private static final int HEIGHT = 140;
    private static final int CORNER_SIZE = 30;
    private static final int SIDE = 30;
    private static final int TOP = 40;
    private static final int BOTTOM = 30;
    private static final int PADDING = 9;
    private static final float MIN_ZOOM = 1.0f;
    private static final float MAX_ZOOM = 2.0f;
    private static final float ZOOM_STEP = 0.2f;
    private final ClientAdvancements clientAdvancements;
    private final Map<Advancement, BetterAdvancementTab> tabs = Maps.newLinkedHashMap();
    private BetterAdvancementTab selectedTab;
    private static int tabPage;
    private static int maxPages;
    private float zoom = 1.0f;
    private boolean isScrolling;
    protected int internalWidth;
    protected int internalHeight;
    public static int uiScaling;
    public static boolean showDebugCoordinates;
    public static boolean orderTabsAlphabetically;
    private BetterAdvancementWidget advConnectedToMouse = null;

    public BetterAdvancementsScreen(ClientAdvancements clientAdvancements) {
        super(GameNarrator.f_93310_);
        this.clientAdvancements = clientAdvancements;
    }

    protected void m_7856_() {
        this.internalHeight = this.f_96544_ * uiScaling / 100;
        this.internalWidth = this.f_96543_ * uiScaling / 100;
        this.tabs.clear();
        this.selectedTab = null;
        this.clientAdvancements.m_104397_((ClientAdvancements.Listener)this);
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            this.clientAdvancements.m_104401_(this.tabs.values().iterator().next().getAdvancement(), true);
        } else {
            this.clientAdvancements.m_104401_(this.selectedTab == null ? null : this.selectedTab.getAdvancement(), true);
        }
        int left = 30 + (this.f_96543_ - this.internalWidth) / 2;
        int top = 40 + (this.f_96544_ - this.internalHeight) / 2;
        int right = this.internalWidth - 30 + (this.f_96543_ - this.internalWidth) / 2;
        int bottom = this.internalHeight - 30 + (this.f_96544_ - this.internalHeight) / 2;
        int width = right - left;
        int height = bottom - top;
        int maxTabs = BetterAdvancementTabType.getMaxTabs(width, height);
        if (this.tabs.size() > maxTabs) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), b -> {
                tabPage = Math.max(tabPage - 1, 0);
            }).m_252794_(left, bottom + 4).m_253046_(20, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), b -> {
                tabPage = Math.min(tabPage + 1, maxPages);
            }).m_252794_(right - 20, bottom + 4).m_253046_(20, 20).m_253136_());
            maxPages = this.tabs.size() / maxTabs;
            tabPage = Math.min(tabPage, maxPages);
        }
    }

    public void m_7379_() {
        this.clientAdvancements.m_104397_(null);
        ClientPacketListener clientpacketlistener = this.f_96541_.m_91403_();
        if (clientpacketlistener != null) {
            clientpacketlistener.m_104955_((Packet)ServerboundSeenAdvancementsPacket.m_134444_());
        }
        super.m_7379_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int modifiers) {
        if (modifiers == 0) {
            int left = 30 + (this.f_96543_ - this.internalWidth) / 2;
            int top = 40 + (this.f_96544_ - this.internalHeight) / 2;
            int right = this.internalWidth - 30 + (this.f_96543_ - this.internalWidth) / 2;
            int bottom = this.internalHeight - 30 + (this.f_96544_ - this.internalHeight) / 2;
            int width = right - left;
            int height = bottom - top;
            int maxTabs = BetterAdvancementTabType.getMaxTabs(width, height);
            int skip = tabPage * maxTabs;
            for (BetterAdvancementTab tab : this.tabs.values().stream().skip(skip).limit(maxTabs).toList()) {
                if (!tab.isMouseOver(left, top, this.internalWidth - 60, this.internalHeight - top - 30, mouseX, mouseY)) continue;
                this.clientAdvancements.m_104401_(tab.getAdvancement(), true);
                break;
            }
        }
        return super.m_6375_(mouseX, mouseY, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (this.selectedTab != null) {
            this.selectedTab.scroll(scroll * 16.0, scroll * 16.0, this.f_96543_, this.f_96544_);
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92055_.m_90832_(keyCode, scanCode)) {
            this.f_96541_.m_91152_(null);
            this.f_96541_.f_91067_.m_91601_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double mouseDeltaX, double mouseDeltaY) {
        int left = 30 + (this.f_96543_ - this.internalWidth) / 2;
        int top = 40 + (this.f_96544_ - this.internalHeight) / 2;
        if (button != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            if (this.advConnectedToMouse == null) {
                boolean inGui;
                boolean bl = inGui = mouseX < (double)(left + this.internalWidth - 60 - 9) && mouseX > (double)(left + 9) && mouseY < (double)(top + this.internalHeight - 40 + 1) && mouseY > (double)(top + 18);
                if (this.selectedTab != null && inGui) {
                    for (BetterAdvancementWidget betterAdvancementEntryScreen : this.selectedTab.widgets.values()) {
                        if (!betterAdvancementEntryScreen.isMouseOver(this.selectedTab.scrollX, this.selectedTab.scrollY, mouseX - (double)left - 9.0, mouseY - (double)top - 18.0) || !betterAdvancementEntryScreen.betterDisplayInfo.allowDragging()) continue;
                        this.advConnectedToMouse = betterAdvancementEntryScreen;
                        break;
                    }
                }
            } else {
                this.advConnectedToMouse.x = (int)Math.round((double)this.advConnectedToMouse.x + mouseDeltaX);
                this.advConnectedToMouse.y = (int)Math.round((double)this.advConnectedToMouse.y + mouseDeltaY);
            }
        } else {
            if (this.advConnectedToMouse != null) {
                Services.PLATFORM.getEventHelper().postAdvancementMovementEvent(this.advConnectedToMouse);
            }
            this.advConnectedToMouse = null;
        }
        if (this.advConnectedToMouse == null) {
            if (!this.isScrolling) {
                this.isScrolling = true;
            } else if (this.selectedTab != null) {
                this.selectedTab.scroll(mouseDeltaX, mouseDeltaY, this.internalWidth - 60 - 27, this.internalHeight - 40 - 30 - 27);
            }
        }
        return true;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int left = 30 + (this.f_96543_ - this.internalWidth) / 2;
        int top = 40 + (this.f_96544_ - this.internalHeight) / 2;
        int right = this.internalWidth - 30 + (this.f_96543_ - this.internalWidth) / 2;
        int bottom = this.internalHeight - 30 + (this.f_96544_ - this.internalHeight) / 2;
        int width = right - left;
        int height = bottom - top;
        int maxTabs = BetterAdvancementTabType.getMaxTabs(width, height);
        int skip = tabPage * maxTabs;
        this.m_280273_(guiGraphics);
        if (maxPages != 0) {
            MutableComponent page = Component.m_237113_((String)String.format("%d / %d", tabPage + 1, maxPages + 1));
            int textWidth = this.f_96547_.m_92852_((FormattedText)page);
            guiGraphics.m_280648_(this.f_96547_, page.m_7532_(), left + (this.internalWidth - textWidth) / 2 - textWidth, bottom + 8, -1);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.renderInside(guiGraphics, mouseX, mouseY, left, top, right, bottom, maxTabs, skip);
        this.renderWindow(guiGraphics, left, top, right, bottom, maxTabs, skip);
        if (this.advConnectedToMouse == null) {
            this.renderToolTips(guiGraphics, mouseX, mouseY, left, top, right, bottom, maxTabs, skip);
        }
        if (this.advConnectedToMouse != null) {
            for (BetterAdvancementWidget betterAdvancementEntryScreen : this.selectedTab.widgets.values()) {
                if (betterAdvancementEntryScreen == this.advConnectedToMouse) continue;
                int x1 = betterAdvancementEntryScreen.x + left + 9 + this.selectedTab.scrollX + 3;
                int x2 = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3;
                int y1 = betterAdvancementEntryScreen.y + top + 18 + this.selectedTab.scrollY;
                int y2 = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY;
                int centerX1 = betterAdvancementEntryScreen.x + left + 9 + this.selectedTab.scrollX + 3 + 13;
                int centerX2 = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3 + 13;
                int centerY1 = betterAdvancementEntryScreen.y + top + 18 + this.selectedTab.scrollY + 13;
                int centerY2 = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY + 13;
                double degrees = Math.toDegrees(Math.atan2(centerX1 - centerX2, centerY1 - centerY2));
                if (degrees < 0.0) {
                    degrees += 360.0;
                }
                if (betterAdvancementEntryScreen.x == this.advConnectedToMouse.x) {
                    if (y1 > y2) {
                        RenderUtil.drawRect(x1, y1 + 26 - 1, x2, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2, y1 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x2, y1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2 + 26 - 1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2, x2, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2 + 26 - 1, y2, 1.0, 65280);
                    } else {
                        RenderUtil.drawRect(x1, y2 + 26 - 1, x2, y1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2 + 26 - 1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2, x2, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2, y1 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x2, y1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2 + 26 - 1, x2 + 26 - 1, y1, 1.0, 65280);
                    }
                }
                if (betterAdvancementEntryScreen.y == this.advConnectedToMouse.y) {
                    if (x1 > x2) {
                        RenderUtil.drawRect(x2, y1, x1 + 26 - 1, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1, y1, x1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x1 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2, y1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2 + 26 - 1, y1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2, y1 + 26 - 1, x1 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                    } else {
                        RenderUtil.drawRect(x2 + 26 - 1, y1, x1, y2, 1.0, 65280);
                        RenderUtil.drawRect(x2, y1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2 + 26 - 1, y1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1, y1, x1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x1 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2 + 26 - 1, y1 + 26 - 1, x1, y2 + 26 - 1, 1.0, 65280);
                    }
                }
                if (degrees != 45.0 && degrees != 135.0 && degrees != 225.0 && degrees != 315.0) continue;
                RenderUtil.drawRect(x1, y1, x1 + 26 - 1, y1, 1.0, 65280);
                RenderUtil.drawRect(x1, y1 + 26 - 1, x1 + 26 - 1, y1 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x1, y1, x1, y1 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x1 + 26 - 1, y1, x1 + 26 - 1, y1 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x2, y2, x2 + 26 - 1, y2, 1.0, 65280);
                RenderUtil.drawRect(x2, y2 + 26 - 1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x2, y2, x2, y2 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x2 + 26 - 1, y2, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                if (degrees == 45.0 || degrees == 225.0) {
                    RenderUtil.drawRect(x1, y1 + 26 - 1, x2, y2 + 26 - 1, 1.0, 65280);
                    RenderUtil.drawRect(x1 + 26 - 1, y1, x2 + 26 - 1, y2, 1.0, 65280);
                    continue;
                }
                if (degrees != 135.0 && degrees != 315.0) continue;
                RenderUtil.drawRect(x1, y1, x2, y2, 1.0, 65280);
                RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
            }
        }
        if (showDebugCoordinates && this.selectedTab != null && mouseX < this.internalWidth - 30 - 9 && mouseX > 39 && mouseY < this.internalHeight - top + 1 && mouseY > top + 18) {
            if (this.advConnectedToMouse != null) {
                int currentX = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3 + 1;
                int n = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY;
                Objects.requireNonNull(this.f_96547_);
                int currentY = n - 9 + 1;
                guiGraphics.m_280488_(this.f_96547_, this.advConnectedToMouse.x + "," + this.advConnectedToMouse.y, currentX, currentY, 0);
            } else {
                int xMouse = mouseX - left - 9;
                int yMouse = mouseY - top - 18;
                int currentX = xMouse - this.selectedTab.scrollX - 3 - 1;
                int currentY = yMouse - this.selectedTab.scrollY - 1;
                String string = currentX + "," + currentY;
                Objects.requireNonNull(this.f_96547_);
                guiGraphics.m_280488_(this.f_96547_, string, mouseX, mouseY - 9, 0);
            }
        }
    }

    private void renderInside(GuiGraphics guiGraphics, int mouseX, int mouseY, int left, int top, int right, int bottom, int maxTabs, int skip) {
        BetterAdvancementTab betterAdvancementTab = this.selectedTab;
        int boxLeft = left + 9;
        int boxTop = top + 18;
        int boxRight = right - 9;
        int boxBottom = bottom - 9;
        int width = boxRight - boxLeft;
        int height = boxBottom - boxTop;
        if (betterAdvancementTab == null) {
            guiGraphics.m_280509_(boxLeft, boxTop, boxRight, boxBottom, -16777216);
            int n = boxLeft + (width - this.f_96547_.m_92852_((FormattedText)NO_ADVANCEMENTS_LABEL)) / 2;
            int n2 = boxTop + height / 2;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280430_(this.f_96547_, NO_ADVANCEMENTS_LABEL, n, n2 - 9, -1);
            int n3 = boxLeft + (width - this.f_96547_.m_92852_((FormattedText)VERY_SAD_LABEL)) / 2;
            int n4 = boxTop + height / 2;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280430_(this.f_96547_, VERY_SAD_LABEL, n3, n4 + 9, -1);
        } else {
            betterAdvancementTab.drawContents(guiGraphics, boxLeft, boxTop, width, height);
        }
    }

    public void renderWindow(GuiGraphics guiGraphics, int left, int top, int right, int bottom, int maxTabs, int skip) {
        RenderSystem.enableBlend();
        guiGraphics.m_280218_(Resources.Gui.WINDOW, left, top, 0, 0, 30, 30);
        RenderUtil.renderRepeating(Resources.Gui.WINDOW, guiGraphics, left + 30, top, this.internalWidth - 30 - 60 - 30, 30, 30, 0, 192, 30);
        guiGraphics.m_280218_(Resources.Gui.WINDOW, right - 30, top, 222, 0, 30, 30);
        RenderUtil.renderRepeating(Resources.Gui.WINDOW, guiGraphics, left, top + 30, 30, bottom - top - 60, 0, 30, 30, 80);
        RenderUtil.renderRepeating(Resources.Gui.WINDOW, guiGraphics, right - 30, top + 30, 30, bottom - top - 60, 222, 30, 30, 80);
        guiGraphics.m_280218_(Resources.Gui.WINDOW, left, bottom - 30, 0, 110, 30, 30);
        RenderUtil.renderRepeating(Resources.Gui.WINDOW, guiGraphics, left + 30, bottom - 30, this.internalWidth - 30 - 60 - 30, 30, 30, 110, 192, 30);
        guiGraphics.m_280218_(Resources.Gui.WINDOW, right - 30, bottom - 30, 222, 110, 30, 30);
        int width = right - left;
        int height = bottom - top;
        if (this.tabs.size() > 1) {
            for (BetterAdvancementTab tab : this.tabs.values().stream().skip(skip).limit(maxTabs).toList()) {
                tab.drawTab(guiGraphics, left, top, width, height, tab == this.selectedTab);
            }
            RenderSystem.defaultBlendFunc();
            for (BetterAdvancementTab tab : this.tabs.values().stream().skip(skip).limit(maxTabs).toList()) {
                tab.drawIcon(guiGraphics, left, top, width, height);
            }
            RenderSystem.disableBlend();
        }
        FormattedCharSequence windowTitle = TITLE.m_7532_();
        if (this.selectedTab != null) {
            windowTitle = FormattedCharSequence.m_144721_((FormattedCharSequence[])new FormattedCharSequence[]{windowTitle, Component.m_237113_((String)" - ").m_7532_(), this.selectedTab.getTitle().m_7532_()});
        }
        guiGraphics.m_280649_(this.f_96547_, windowTitle, left + 8, top + 6, 0x404040, false);
    }

    private void renderToolTips(GuiGraphics guiGraphics, int mouseX, int mouseY, int left, int top, int right, int bottom, int maxTabs, int skip) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedTab != null) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_((double)(left + 9), (double)(top + 18), 400.0);
            RenderSystem.enableDepthTest();
            this.selectedTab.drawToolTips(guiGraphics, mouseX - left - 9, mouseY - top - 18, left, top, right - left - 18, bottom - top - 27);
            RenderSystem.disableDepthTest();
            guiGraphics.m_280168_().m_85849_();
        }
        int width = right - left;
        int height = bottom - top;
        if (this.tabs.size() > 1) {
            for (BetterAdvancementTab tab : this.tabs.values().stream().skip(skip).limit(maxTabs).toList()) {
                if (!tab.isMouseOver(left, top, width, height, mouseX, mouseY)) continue;
                guiGraphics.m_280557_(this.f_96547_, tab.getTitle(), mouseX, mouseY);
            }
        }
    }

    public void m_5513_(Advancement advancement) {
        BetterAdvancementTab betterAdvancementTabGui = BetterAdvancementTab.create(this.f_96541_, this, this.tabs.size(), advancement, this.internalWidth - 60, this.internalHeight - 40 - 30);
        if (betterAdvancementTabGui != null) {
            this.tabs.put(advancement, betterAdvancementTabGui);
        }
    }

    public void m_5504_(Advancement advancement) {
    }

    public void m_5505_(Advancement advancement) {
        BetterAdvancementTab betterAdvancementTabGui = this.getTab(advancement);
        if (betterAdvancementTabGui != null) {
            betterAdvancementTabGui.addAdvancement(advancement);
        }
    }

    public void m_5516_(Advancement advancement) {
    }

    public void m_7922_(Advancement advancement, AdvancementProgress advancementProgress) {
        BetterAdvancementWidget betterAdvancementEntryScreen = this.getAdvancementWidget(advancement);
        if (betterAdvancementEntryScreen != null) {
            betterAdvancementEntryScreen.getAdvancementProgress(advancementProgress);
        }
    }

    public void m_6896_(Advancement advancement) {
        if (this.selectedTab != null) {
            this.selectedTab.storeScroll();
        }
        this.selectedTab = this.tabs.get(advancement);
        if (this.selectedTab != null) {
            this.selectedTab.loadScroll();
        }
    }

    public void m_7204_() {
        this.tabs.clear();
        this.selectedTab = null;
    }

    public BetterAdvancementWidget getAdvancementWidget(Advancement advancement) {
        BetterAdvancementTab betterAdvancementTab = this.getTab(advancement);
        return betterAdvancementTab == null ? null : betterAdvancementTab.getWidget(advancement);
    }

    private BetterAdvancementTab getTab(Advancement advancement) {
        while (advancement.m_138319_() != null) {
            advancement = advancement.m_138319_();
        }
        return this.tabs.get(advancement);
    }

    static {
        uiScaling = 100;
        showDebugCoordinates = false;
        orderTabsAlphabetically = false;
    }
}

