/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.packets;

import com.hollingsworth.arsnouveau.common.block.tile.RuneTile;
import java.util.function.Supplier;
import net.mcreator.ars_technica.common.api.IRuneTileModifier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class TicksUntilChargePacket {
    private final int ticksUntilChargeCount;
    private final BlockPos blockPos;

    public TicksUntilChargePacket(int ticksUntilChargeCount, BlockPos blockPos) {
        this.ticksUntilChargeCount = ticksUntilChargeCount;
        this.blockPos = blockPos;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.ticksUntilChargeCount);
        buffer.m_130064_(this.blockPos);
    }

    public static TicksUntilChargePacket decode(FriendlyByteBuf buffer) {
        int ticks = buffer.readInt();
        BlockPos pos = buffer.m_130135_();
        return new TicksUntilChargePacket(ticks, pos);
    }

    public static void handle(TicksUntilChargePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            RuneTile runeTile;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Level level = player.m_9236_();
            BlockEntity patt1542$temp = level.m_7702_(packet.blockPos);
            if (patt1542$temp instanceof RuneTile && (runeTile = (RuneTile)patt1542$temp) instanceof IRuneTileModifier) {
                IRuneTileModifier customizable = (IRuneTileModifier)runeTile;
                customizable.setTicksUntilChargeCount(packet.ticksUntilChargeCount);
                runeTile.m_6596_();
            }
        });
        context.setPacketHandled(true);
    }
}

