/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.helpers;

import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class StorageHelpers {
    public static ItemScroll.SortPref canDepositItem(Level level, BlockEntity tile, ItemStack stack) {
        ItemScroll.SortPref pref = ItemScroll.SortPref.LOW;
        if (tile == null || stack == null || stack.m_41619_()) {
            return ItemScroll.SortPref.INVALID;
        }
        IItemHandler handler = StorageHelpers.getItemCapFromTile(tile);
        if (handler == null) {
            return ItemScroll.SortPref.INVALID;
        }
        for (ItemFrame itemFrame : level.m_45976_(ItemFrame.class, new AABB(tile.m_58899_()).m_82400_(1.0))) {
            ItemStack stackInFrame;
            Direction facing;
            BlockPos framePos = itemFrame.m_20183_();
            BlockPos attachedBlockPos = framePos.m_121945_((facing = itemFrame.m_6350_()).m_122424_());
            BlockEntity adjTile = level.m_7702_(attachedBlockPos);
            if (adjTile == null || !adjTile.equals(tile) || (stackInFrame = itemFrame.m_31822_()).m_41619_()) continue;
            Item item = stackInFrame.m_41720_();
            if (item instanceof ItemScroll) {
                ItemScroll scrollItem = (ItemScroll)item;
                pref = scrollItem.getSortPref(stack, stackInFrame, handler);
                continue;
            }
            if (stackInFrame.m_41720_().equals(stack.m_41720_())) {
                pref = ItemScroll.SortPref.HIGHEST;
                continue;
            }
            return ItemScroll.SortPref.INVALID;
        }
        return !ItemStack.m_41728_((ItemStack)ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack.m_41777_(), (boolean)true), (ItemStack)stack) ? pref : ItemScroll.SortPref.INVALID;
    }

    public static BlockPos getValidStorePos(Level level, List<BlockPos> containerPosTargets, ItemStack stack) {
        if (containerPosTargets.isEmpty() || stack.m_41619_()) {
            return null;
        }
        BlockPos returnPos = null;
        ItemScroll.SortPref foundPref = ItemScroll.SortPref.INVALID;
        for (BlockPos b : containerPosTargets) {
            ItemScroll.SortPref pref = StorageHelpers.sortPrefForStack(level, b, stack);
            if (pref.ordinal() <= foundPref.ordinal()) continue;
            foundPref = pref;
            returnPos = b;
            if (foundPref != ItemScroll.SortPref.HIGHEST) continue;
            return returnPos;
        }
        return returnPos;
    }

    public static List<BlockPos> getValidStorePositions(Level level, List<BlockPos> containerPosTargets, ItemStack stack) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (BlockPos pos : containerPosTargets) {
            if (StorageHelpers.sortPrefForStack(level, pos, stack) == ItemScroll.SortPref.INVALID) continue;
            validPositions.add(pos);
        }
        return validPositions;
    }

    public static ItemScroll.SortPref sortPrefForStack(Level level, @Nullable BlockPos b, ItemStack stack) {
        if (stack == null || stack.m_41619_() || b == null || !level.m_46749_(b)) {
            return ItemScroll.SortPref.INVALID;
        }
        return StorageHelpers.canDepositItem(level, level.m_7702_(b), stack);
    }

    @Nullable
    public static IItemHandler getItemCapFromTile(BlockEntity blockEntity) {
        Optional lazy;
        if (blockEntity != null && blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() && (lazy = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve()).isPresent()) {
            return (IItemHandler)lazy.get();
        }
        return null;
    }
}

