/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.client.events;

import com.hollingsworth.arsnouveau.api.perk.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.mcreator.ars_technica.client.AllPartialModels;
import net.mcreator.ars_technica.client.renderer.entity.ArcaneFusionEntityRenderer;
import net.mcreator.ars_technica.client.renderer.entity.ArcaneHammerEntityRenderer;
import net.mcreator.ars_technica.client.renderer.entity.ArcanePolishEntityRenderer;
import net.mcreator.ars_technica.client.renderer.entity.ArcanePressEntityRenderer;
import net.mcreator.ars_technica.client.renderer.entity.ItemProjectileRenderer;
import net.mcreator.ars_technica.client.renderer.entity.WhirlEntityRenderer;
import net.mcreator.ars_technica.client.renderer.tile.EncasedBasicTurretRenderer;
import net.mcreator.ars_technica.client.sound.EntityLoopingSound;
import net.mcreator.ars_technica.common.blocks.PreciseRelayRenderer;
import net.mcreator.ars_technica.common.blocks.SourceEngineRenderer;
import net.mcreator.ars_technica.common.entity.WhirlEntity;
import net.mcreator.ars_technica.common.items.equipment.SpyMonocleCurioRenderer;
import net.mcreator.ars_technica.init.ArsTechnicaModSounds;
import net.mcreator.ars_technica.ponder.ArsTechnicaPlugin;
import net.mcreator.ars_technica.setup.EntityRegistry;
import net.mcreator.ars_technica.setup.ItemsRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="ars_technica", bus=Mod.EventBusSubscriber.Bus.MOD)
@OnlyIn(value=Dist.CLIENT)
public class ClientHandler {
    private static float DEFAULT_PITCH = 0.8f;
    private static float SPEED_PITCH_MULTIPLIER = 4.0f;

    @SubscribeEvent
    public static void initItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{(ItemLike)ItemsRegistry.TECHNOMANCER_BOOTS.get()});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{(ItemLike)ItemsRegistry.TECHNOMANCER_CHESTPLATE.get()});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{(ItemLike)ItemsRegistry.TECHNOMANCER_HELMET.get()});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{(ItemLike)ItemsRegistry.TECHNOMANCER_LEGGINGS.get()});
    }

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        AllPartialModels.init();
        PonderIndex.addPlugin((PonderPlugin)new ArsTechnicaPlugin());
    }

    @SubscribeEvent
    public static void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SpyMonocleCurioRenderer.SPY_MONOCLE_LAYER, () -> SpyMonocleCurioRenderer.createBodyLayer());
    }

    public static void handleWhirlSound(WhirlEntity entity, FanProcessingType processor, float speed) {
        SoundEvent event = ClientHandler.getLoopingSoundFromType(processor);
        EntityLoopingSound sound = new EntityLoopingSound(entity, event, 0.5f, DEFAULT_PITCH + SPEED_PITCH_MULTIPLIER * speed);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
    }

    private static SoundEvent getLoopingSoundFromType(FanProcessingType processor) {
        if (processor == AllFanProcessingTypes.HAUNTING) {
            return (SoundEvent)ArsTechnicaModSounds.WHIRL_HAUNT.get();
        }
        if (processor == AllFanProcessingTypes.SPLASHING) {
            return (SoundEvent)ArsTechnicaModSounds.WHIRL_SPLASH.get();
        }
        if (processor == AllFanProcessingTypes.SMOKING || processor == AllFanProcessingTypes.BLASTING) {
            return (SoundEvent)ArsTechnicaModSounds.WHIRL_SMELT.get();
        }
        return (SoundEvent)ArsTechnicaModSounds.WHIRL_NONE.get();
    }

    public static int colorFromArmor(ItemStack stack) {
        IPerkHolder holder = PerkUtil.getPerkHolder((ItemStack)stack);
        if (!(holder instanceof ArmorPerkHolder)) {
            return DyeColor.BROWN.m_41071_();
        }
        ArmorPerkHolder armorPerkHolder = (ArmorPerkHolder)holder;
        return DyeColor.m_41057_((String)armorPerkHolder.getColor(), (DyeColor)DyeColor.BROWN).m_41071_();
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityRegistry.WHIRL_ENTITY.get(), WhirlEntityRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.ARCANE_PRESS_ENTITY.get(), ArcanePressEntityRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.ARCANE_POLISH_ENTITY.get(), ArcanePolishEntityRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.ARCANE_HAMMER_ENTITY.get(), ArcaneHammerEntityRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.ARCANE_FUSION_ENTITY.get(), ArcaneFusionEntityRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.ITEM_PROJECTILE_ENTITY.get(), ItemProjectileRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)EntityRegistry.SOURCE_ENGINE_BLOCK_ENTITY.get(), SourceEngineRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)EntityRegistry.ENCASED_TURRET_TILE.get(), EncasedBasicTurretRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)EntityRegistry.PRECISE_RELAY_TILE.get(), PreciseRelayRenderer::new);
    }
}

