/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.reflect.auto;

import com.glodblock.github.glodium.Glodium;
import com.glodblock.github.glodium.reflect.ReflectKit;
import com.glodblock.github.glodium.reflect.auto.AutoReflect;
import com.glodblock.github.glodium.reflect.auto.ConObj;
import com.glodblock.github.glodium.reflect.auto.FieldObj;
import com.glodblock.github.glodium.reflect.auto.MethodObj;
import com.glodblock.github.glodium.reflect.auto.ReflectHost;
import com.glodblock.github.glodium.reflect.auto.ReflectObj;
import com.glodblock.github.glodium.util.GlodUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraftforge.api.distmarker.Dist;
import org.slf4j.Logger;

public class AutoReflects {
    public static void process(Class<?> clazz, Logger logger) {
        AutoReflects.processInternal(clazz, null, logger);
    }

    public static void process(Object holder, Logger logger) {
        AutoReflects.processInternal(holder.getClass(), holder, logger);
    }

    private static void processInternal(Class<?> clazz, Object obj, Logger logger) {
        if (clazz.isAnnotationPresent(ReflectHost.class)) {
            Field[] fields;
            boolean silent = clazz.getAnnotation(ReflectHost.class).silent();
            for (Field rf : fields = clazz.getDeclaredFields()) {
                AutoReflect property;
                if (!rf.isAnnotationPresent(AutoReflect.class) || !AutoReflects.checkSide((property = rf.getAnnotation(AutoReflect.class)).side())) continue;
                try {
                    ReflectObj field;
                    rf.setAccessible(true);
                    Class<?> host = AutoReflects.getClazz(property.host(), property.path());
                    if (rf.getType() == FieldObj.class) {
                        field = new FieldObj(ReflectKit.reflectField(host, property.name()));
                        ReflectKit.writeField(obj, rf, field);
                    }
                    if (rf.getType() == MethodObj.class) {
                        field = new MethodObj(ReflectKit.reflectMethod(host, property.name(), property.paras()));
                        ReflectKit.writeField(obj, rf, field);
                    }
                    if (rf.getType() != ConObj.class) continue;
                    field = new ConObj(ReflectKit.reflectCon(host, property.paras()));
                    ReflectKit.writeField(obj, rf, field);
                }
                catch (Throwable e) {
                    if (silent) continue;
                    logger.error("Fail to init reflection in {}. Properties[host={}, path={}, names={}, paras={}, side={}]", new Object[]{clazz.getName(), property.host(), property.path(), property.name(), property.paras(), property.side()});
                    logger.error(e.getMessage());
                }
            }
        } else {
            Glodium.LOGGER.warn("{} is missing reflection annotation.", (Object)clazz.getName());
        }
    }

    private static boolean checkSide(AutoReflect.Environment isClient) {
        return switch (isClient) {
            default -> throw new IncompatibleClassChangeError();
            case AutoReflect.Environment.ALL -> true;
            case AutoReflect.Environment.SERVER -> {
                if (GlodUtil.side() == Dist.DEDICATED_SERVER) {
                    yield true;
                }
                yield false;
            }
            case AutoReflect.Environment.CLIENT -> GlodUtil.side() == Dist.CLIENT;
        };
    }

    private static Class<?> getClazz(Class<?> clazz, String[] alt) throws ClassNotFoundException {
        if (clazz != AutoReflect.NAC.class) {
            return clazz;
        }
        for (String path : alt) {
            try {
                return Class.forName(path);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(Arrays.toString(alt));
    }
}

