/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.common.crafting.recipes.IDyeable;
import com.hollingsworth.arsnouveau.common.crafting.recipes.RecipeUtil;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CraftingHelper;

public class DyeRecipe
extends ShapelessRecipe {
    public DyeRecipe(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        super(idIn, groupIn, CraftingBookCategory.MISC, recipeOutputIn, recipeItemsIn);
    }

    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess p_266797_) {
        ItemStack output = super.m_5874_(inv, p_266797_);
        if (!output.m_41619_()) {
            ItemStack ingredient;
            int i;
            for (i = 0; i < inv.m_6643_(); ++i) {
                ingredient = inv.m_8020_(i);
                if (ingredient.m_41619_() || !(ingredient.m_41720_() instanceof IDyeable)) continue;
                output.m_41751_(ingredient.m_41784_().m_6426_());
            }
            for (i = 0; i < inv.m_6643_(); ++i) {
                Item item;
                ingredient = inv.m_8020_(i);
                DyeColor color = DyeColor.getColor((ItemStack)ingredient);
                if (ingredient.m_41619_() || color == null || !((item = output.m_41720_()) instanceof IDyeable)) continue;
                IDyeable dyeable = (IDyeable)item;
                dyeable.onDye(output, color);
            }
        }
        return output;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.DYE_RECIPE.get();
    }

    public static JsonElement asRecipe(Item item) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "ars_nouveau:dye");
        JsonArray ingredients = new JsonArray();
        JsonObject dyeObject = new JsonObject();
        dyeObject.addProperty("tag", Tags.Items.DYES.f_203868_().toString());
        ingredients.add((JsonElement)dyeObject);
        JsonObject input = new JsonObject();
        input.addProperty("item", RegistryHelper.getRegistryName(item).toString());
        ingredients.add((JsonElement)input);
        jsonobject.add("ingredients", (JsonElement)ingredients);
        JsonObject itemObject = new JsonObject();
        itemObject.addProperty("item", RegistryHelper.getRegistryName(item).toString());
        jsonobject.add("result", (JsonElement)itemObject);
        return jsonobject;
    }

    public static class Serializer
    implements RecipeSerializer<DyeRecipe> {
        public DyeRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = RecipeUtil.parseShapeless(json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            return new DyeRecipe(recipeID, group, result, ingredients);
        }

        public DyeRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            int numIngredients = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)numIngredients, (Object)Ingredient.f_43901_);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            return new DyeRecipe(recipeID, group, result, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, DyeRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
        }
    }
}

