/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.item;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.renderer.item.FixedGeoItemRenderer;
import com.hollingsworth.arsnouveau.common.items.ScryCaster;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.model.GeoModel;

public class ScryCasterRenderer
extends FixedGeoItemRenderer<ScryCaster> {
    public ScryCasterRenderer() {
        super((GeoModel)new GeoModel<ScryCaster>(){

            public ResourceLocation getModelResource(ScryCaster wand) {
                return new ResourceLocation("ars_nouveau", "geo/enchanters_eye.geo.json");
            }

            public ResourceLocation getTextureResource(ScryCaster wand) {
                return new ResourceLocation("ars_nouveau", "textures/item/enchanters_eye.png");
            }

            public ResourceLocation getAnimationResource(ScryCaster wand) {
                return new ResourceLocation("ars_nouveau", "animations/enchanters_eye.json");
            }
        });
    }

    public void renderRecursively(PoseStack poseStack, ScryCaster animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.getName().equals("eye")) {
            super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        } else {
            super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, (float)Color.WHITE.getRed() / 255.0f, (float)Color.WHITE.getGreen() / 255.0f, (float)Color.WHITE.getBlue() / 255.0f, (float)Color.WHITE.getAlpha() / 255.0f);
        }
    }

    public Color getRenderColor(ScryCaster animatable, float partialTick, int packedLight) {
        ParticleColor color = ParticleColor.defaultParticleColor();
        if (this.currentItemStack.m_41782_() && this.currentItemStack.m_41784_().m_128441_("ars_nouveau:caster")) {
            color = animatable.getSpellCaster(this.currentItemStack).getColor();
        }
        return Color.ofRGBA((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)0.85f).brighter((double)1.2f);
    }

    public RenderType getRenderType(ScryCaster animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110473_((ResourceLocation)texture);
    }
}

