/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.clickmachine.gui;

import dev.shadowsoffire.clickmachine.ClickMachineConfig;
import dev.shadowsoffire.clickmachine.gui.ClickMachineMenu;
import dev.shadowsoffire.clickmachine.gui.ClickMachineScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class SpeedSlider
extends AbstractSliderButton {
    protected static final int minValue = 0;
    protected static final int maxValue = 8;
    protected static final float stepSize = 0.11111111f;
    protected final ClickMachineScreen gui;

    public SpeedSlider(ClickMachineScreen gui, int x, int y, int width, int height) {
        super(x, y, width, height, CommonComponents.EMPTY, SpeedSlider.normalizeValue(((ClickMachineMenu)gui.getMenu()).getSpeedIdx()));
        this.gui = gui;
        this.updateMessage();
    }

    protected void updateMessage() {
        int spd = SpeedSlider.denormalizeValue(this.value);
        int ticksPerClick = ClickMachineConfig.speeds[spd];
        if (ticksPerClick <= 20) {
            double cps = 1.0 / (double)ticksPerClick * 20.0;
            this.setMessage((Component)Component.translatable((String)"gui.clickmachine.speed", (Object[])new Object[]{String.format("%.2f", cps)}));
        } else {
            double spc = (double)ticksPerClick / 20.0;
            this.setMessage((Component)Component.translatable((String)"gui.clickmachine.speed_slow", (Object[])new Object[]{String.format("%.2f", spc)}));
        }
    }

    protected void applyValue() {
        Minecraft.getInstance().gameMode.handleInventoryButtonClick(((ClickMachineMenu)this.gui.getMenu()).containerId, 4 + SpeedSlider.denormalizeValue(this.value));
    }

    public void setValue(int value) {
        if (!this.gui.isDragging()) {
            this.value = SpeedSlider.normalizeValue(value);
            this.updateMessage();
        }
    }

    public static double normalizeValue(double value) {
        return Mth.clamp((double)((SpeedSlider.snapToStepClamp(value) - 0.0) / 8.0), (double)0.0, (double)1.0);
    }

    public static int denormalizeValue(double value) {
        return (int)SpeedSlider.snapToStepClamp(Mth.lerp((double)Mth.clamp((double)value, (double)0.0, (double)1.0), (double)0.0, (double)8.0));
    }

    private static double snapToStepClamp(double valueIn) {
        valueIn = 0.11111111f * (float)Math.round(valueIn / 0.1111111119389534);
        return Mth.clamp((double)valueIn, (double)0.0, (double)8.0);
    }
}

