/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.clickmachine.gui;

import dev.shadowsoffire.clickmachine.ClickMachine;
import dev.shadowsoffire.clickmachine.block.ClickMachineTile;
import dev.shadowsoffire.placebo.menu.BlockEntityMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.items.SlotItemHandler;

public class ClickMachineMenu
extends BlockEntityMenu<ClickMachineTile> {
    public ClickMachineMenu(int id, Inventory pInv, BlockPos pos) {
        super(ClickMachine.CLICK_MACHINE_MENU, id, pInv, pos);
        this.addSlot((Slot)new SlotItemHandler(((ClickMachineTile)this.tile).getHandler(), 0, 8, 50));
        this.addPlayerSlots(pInv, 8, 114);
        this.mover.registerRule((stack, slot) -> slot == 0, 1, this.slots.size());
        this.mover.registerRule((stack, slot) -> slot > 0, 0, 1);
    }

    public boolean stillValid(Player player) {
        return this.tile != null && !((ClickMachineTile)this.tile).isRemoved();
    }

    public boolean clickMenuButton(Player pPlayer, int button) {
        if (button == 2) {
            ((ClickMachineTile)this.tile).setSneaking(!((ClickMachineTile)this.tile).isSneaking());
        } else if (button == 3) {
            ((ClickMachineTile)this.tile).setRightClicking(!((ClickMachineTile)this.tile).isRightClicking());
        } else if (button >= 4 && button <= 12) {
            ((ClickMachineTile)this.tile).setSpeedIndex(button - 4);
        }
        return button <= 12;
    }

    public boolean isSneaking() {
        return ((ClickMachineTile)this.tile).isSneaking();
    }

    public boolean isRightClicking() {
        return ((ClickMachineTile)this.tile).isRightClicking();
    }

    public int getEnergy() {
        return ((ClickMachineTile)this.tile).getPower();
    }

    public int getSpeedIdx() {
        return ((ClickMachineTile)this.tile).getSpeedIndex();
    }
}

