/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.clickmachine;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import dev.shadowsoffire.clickmachine.ClickMachine;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClickMachineConfig {
    public static int[] speeds = new int[]{500, 200, 100, 50, 20, 10, 5, 2, 1};
    public static boolean usesRF = false;
    public static int maxPowerStorage = 50000;
    public static int[] powerPerSpeed = new int[]{0, 3, 5, 10, 25, 50, 100, 250, 500};
    public static Set<Item> blacklistedItems = new HashSet<Item>();

    public static void init(Configuration cfg) {
        String[] blacklist;
        int i;
        String[] def = new String[9];
        for (int i2 = 0; i2 < 9; ++i2) {
            def[i2] = Integer.valueOf(speeds[i2]).toString();
        }
        String[] unparsed = cfg.getStringList("Speeds", "general", def, "The possible speeds of the auto clicker, in ticks between clicks (ex: 100 = 1 click every 5s). Must have 9 values.");
        for (i = 0; i < 9; ++i) {
            try {
                ClickMachineConfig.speeds[i] = Integer.parseInt(unparsed[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException ex) {
                ClickMachine.LOG.error("Failed to parse Speeds value for index {}, reverting to default.", (Object)i);
                ex.printStackTrace();
                ClickMachineConfig.speeds[i] = Integer.parseInt(def[i]);
            }
        }
        usesRF = cfg.getBoolean("Uses RF", "general", usesRF, "If the auto clicker uses RF");
        def = new String[9];
        for (i = 0; i < 9; ++i) {
            def[i] = Integer.valueOf(powerPerSpeed[i]).toString();
        }
        unparsed = cfg.getStringList("RF Costs", "general", def, "The RF cost per tick for each speed, from 0-8.  Must have 9 values.  Unused if \"Uses RF\" = false");
        for (i = 0; i < 9; ++i) {
            try {
                ClickMachineConfig.powerPerSpeed[i] = Integer.parseInt(unparsed[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException ex) {
                ClickMachine.LOG.error("Failed to parse RF Costs value for index {}, reverting to default.", (Object)i);
                ex.printStackTrace();
                ClickMachineConfig.powerPerSpeed[i] = Integer.parseInt(def[i]);
            }
        }
        maxPowerStorage = cfg.getInt("Max Power Storage", "general", maxPowerStorage, 0, Integer.MAX_VALUE, "How much power the auto clicker can store.  Also the max input rate.  Unused if \"Uses RF\" = false");
        ImmutableSet.Builder set = ImmutableSet.builder();
        for (String s : blacklist = cfg.getStringList("Item Blacklist", "general", new String[]{"minecraft:bedrock"}, "Items that may not be held by the clicker")) {
            try {
                Item i3 = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)s));
                if (i3 == Items.AIR) {
                    throw new NullPointerException("Unknown Item: " + s);
                }
                set.add((Object)i3);
            }
            catch (Exception ex) {
                ClickMachine.LOG.error("Failed to parse unknown item \"{}\" in Click Machine Blacklist.", (Object)s);
                ex.printStackTrace();
            }
        }
        blacklistedItems = set.build();
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    public record ConfigPayload(List<Integer> speeds, boolean usesRF, int maxPower, List<Integer> powerPerSpeed, Set<Item> blacklist) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ConfigPayload> TYPE = new CustomPacketPayload.Type(ClickMachine.loc("config"));
        public static final StreamCodec<RegistryFriendlyByteBuf, ConfigPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list()), ConfigPayload::speeds, (StreamCodec)ByteBufCodecs.BOOL, ConfigPayload::usesRF, (StreamCodec)ByteBufCodecs.INT, ConfigPayload::maxPower, (StreamCodec)ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list()), ConfigPayload::powerPerSpeed, (StreamCodec)ByteBufCodecs.collection(HashSet::new, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM)), ConfigPayload::blacklist, ConfigPayload::new);

        public ConfigPayload() {
            this(Ints.asList((int[])speeds), usesRF, maxPowerStorage, Ints.asList((int[])powerPerSpeed), blacklistedItems);
        }

        public CustomPacketPayload.Type<ConfigPayload> type() {
            return TYPE;
        }

        public static class Provider
        implements PayloadProvider<ConfigPayload> {
            public CustomPacketPayload.Type<ConfigPayload> getType() {
                return TYPE;
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, ConfigPayload> getCodec() {
                return CODEC;
            }

            public void handle(ConfigPayload msg, IPayloadContext ctx) {
                ClickMachineConfig.speeds = Ints.toArray(msg.speeds);
                ClickMachineConfig.usesRF = msg.usesRF;
                maxPowerStorage = msg.maxPower;
                ClickMachineConfig.powerPerSpeed = Ints.toArray(msg.powerPerSpeed);
                blacklistedItems = msg.blacklist;
            }

            public List<ConnectionProtocol> getSupportedProtocols() {
                return List.of(ConnectionProtocol.PLAY);
            }

            public Optional<PacketFlow> getFlow() {
                return Optional.of(PacketFlow.CLIENTBOUND);
            }

            public String getVersion() {
                return "1";
            }
        }
    }
}

