/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import website.eccentric.tome.EccentricTome;
import website.eccentric.tome.core.TomeManager;

public record RevertToTomePacket() implements CustomPacketPayload
{
    public static final RevertToTomePacket INSTANCE = new RevertToTomePacket();
    public static final CustomPacketPayload.Type<RevertToTomePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"eccentrictome", (String)"revert_to_tome"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RevertToTomePacket> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(RevertToTomePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ItemStack bookStack;
            ItemStack tomeStack;
            Player player = context.player();
            InteractionHand hand = TomeManager.getBookHand(player);
            if (hand != null && !(tomeStack = TomeManager.revertToTome(bookStack = player.getItemInHand(hand))).isEmpty()) {
                player.setItemInHand(hand, tomeStack);
                if (context.flow().getReceptionSide().isClient()) {
                    Minecraft.getInstance().gameRenderer.itemInHandRenderer.itemUsed(hand);
                }
                EccentricTome.LOGGER.debug("Reverted to tome");
            }
        });
    }
}

