/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import website.eccentric.tome.EccentricDataComponents;
import website.eccentric.tome.ModName;
import website.eccentric.tome.TomeClientUtils;
import website.eccentric.tome.core.TomeData;
import website.eccentric.tome.network.SelectBookPacket;

public class TomeItem
extends Item {
    public TomeItem() {
        super(new Item.Properties().stacksTo(1).component(EccentricDataComponents.TOME_DATA, (Object)TomeData.EMPTY));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack tome = context.getItemInHand();
        String mod = ModName.from(context.getLevel().getBlockState(context.getClickedPos()));
        TomeData data = (TomeData)tome.getOrDefault(EccentricDataComponents.TOME_DATA.get(), (Object)TomeData.EMPTY);
        if (!player.isShiftKeyDown() || !data.books().containsKey(mod)) {
            return InteractionResult.PASS;
        }
        List<ItemStack> books = data.books().get(mod);
        if (!books.isEmpty() && context.getLevel().isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SelectBookPacket(mod, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack tome = player.getItemInHand(hand);
        if (level.isClientSide) {
            TomeClientUtils.openTome(tome);
        }
        return InteractionResultHolder.sidedSuccess((Object)tome, (boolean)level.isClientSide);
    }

    public void appendHoverText(ItemStack tome, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag advanced) {
        TomeData data = (TomeData)tome.getOrDefault(EccentricDataComponents.TOME_DATA.get(), (Object)TomeData.EMPTY);
        for (Map.Entry<String, List<ItemStack>> entry : data.books().entrySet()) {
            tooltip.add((Component)Component.literal((String)ModName.name(entry.getKey())));
            for (ItemStack book : entry.getValue()) {
                if (book.is(Items.AIR)) continue;
                String name = book.getHoverName().getString();
                tooltip.add((Component)Component.literal((String)("  " + String.valueOf(ChatFormatting.GRAY) + name)));
            }
        }
    }
}

