/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.gui;

import de.maxhenkel.gravestone.gui.ObituaryScreen;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class Page {
    private static final int ITEM_START_Y = 60;
    private ItemStack[] items;
    private ObituaryScreen gui;

    public Page(ItemStack[] it, ObituaryScreen gui) {
        this.gui = gui;
        int arraySize = 10;
        this.items = new ItemStack[10];
        if (it.length < 10) {
            arraySize = it.length;
        }
        for (int i = 0; i < this.items.length && i < arraySize; ++i) {
            this.items[i] = it[i];
        }
    }

    public void drawPage(GuiGraphics guiGraphics, int page, int pageCount, int mouseX, int mouseY) {
        int index;
        ItemStack stack;
        this.gui.drawCentered(guiGraphics, this.gui.getFontRenderer(), Component.translatable((String)"gui.obituary.title.items").withStyle(ChatFormatting.UNDERLINE), this.gui.width / 2, 30, ChatFormatting.BLACK.getColor());
        this.gui.drawCentered(guiGraphics, this.gui.getFontRenderer(), Component.translatable((String)"gui.obituary.page", (Object[])new Object[]{page, pageCount}), this.gui.width / 2, 43, ChatFormatting.DARK_GRAY.getColor());
        int y = 60;
        int space = 12;
        for (ItemStack s : this.items) {
            if (s == null || s.isEmpty()) continue;
            this.gui.drawItem(guiGraphics, Component.translatable((String)s.getDescriptionId()).withStyle(ChatFormatting.ITALIC), y);
            this.gui.drawItemSize(guiGraphics, Component.literal((String)String.valueOf(s.getCount())), y);
            y += 12;
        }
        if (mouseX >= this.gui.getGuiLeft() + 15 && mouseX <= this.gui.getGuiLeft() + 163 - 14 && mouseY >= 60 && mouseY <= 180 && (stack = this.items[Math.max(0, Math.min(this.items.length - 1, index = (mouseY + 3 - 60) / 12))]) != null && !stack.isEmpty()) {
            guiGraphics.renderTooltip(this.gui.getFontRenderer(), stack, mouseX, mouseY);
        }
    }

    public String toString() {
        return Arrays.toString(this.items);
    }
}

