/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.util;

import com.traverse.bhc.common.BaubleyHeartCanisters;
import com.traverse.bhc.common.config.ConfigHandler;
import com.traverse.bhc.common.init.RegistryHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

@EventBusSubscriber(modid="bhc")
public class DropHandler {
    private static final boolean TCONSTRUCT_LOADED = ModList.get().isLoaded("tinkersconstruct");

    @SubscribeEvent
    public static void onEntityDrop(LivingDropsEvent event) {
        LivingEntity livingEntity;
        LivingEntity entity = event.getEntity();
        if (entity.level().isClientSide || entity instanceof Player) {
            return;
        }
        if (!TCONSTRUCT_LOADED && entity instanceof WitherSkeleton && entity.level().random.nextDouble() < (Double)ConfigHandler.general.boneDropRate.get()) {
            entity.spawnAtLocation((ItemLike)RegistryHandler.WITHER_BONE.get(), 1);
        }
        if ((livingEntity = event.getEntity()) instanceof Warden) {
            Warden warden = (Warden)livingEntity;
            if (warden.level().random.nextDouble() < (Double)ConfigHandler.general.echoShardDropRate.get()) {
                entity.spawnAtLocation((ItemLike)Items.ECHO_SHARD, 1);
            }
        }
        for (ItemStack stack : DropHandler.getEntityDrops(entity)) {
            entity.spawnAtLocation((ItemLike)stack.getItem(), 0);
        }
    }

    public static List<ItemStack> getEntityDrops(LivingEntity entity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        DropHandler.handleEntry("red", entity, list);
        DropHandler.handleEntry("yellow", entity, list);
        DropHandler.handleEntry("green", entity, list);
        DropHandler.handleEntry("blue", entity, list);
        return list;
    }

    public static void handleEntry(String category, LivingEntity entity, List<ItemStack> items) {
        for (Map.Entry<String, Double> entry : BaubleyHeartCanisters.config.getHeartTypeEntries(category).entrySet()) {
            ItemStack stack = ItemStack.EMPTY;
            switch (category) {
                case "red": {
                    stack = new ItemStack((ItemLike)RegistryHandler.RED_HEART.get());
                    break;
                }
                case "yellow": {
                    stack = new ItemStack((ItemLike)RegistryHandler.YELLOW_HEART.get());
                    break;
                }
                case "green": {
                    stack = new ItemStack((ItemLike)RegistryHandler.GREEN_HEART.get());
                    break;
                }
                case "blue": {
                    stack = new ItemStack((ItemLike)RegistryHandler.BLUE_HEART.get());
                }
            }
            if (entry.getKey().equals(entity.getEncodeId())) {
                DropHandler.addWithPercent(items, stack, entry.getValue());
                continue;
            }
            switch (entry.getKey()) {
                case "passive": {
                    if (entity instanceof Monster || entity instanceof Player) break;
                    DropHandler.addWithPercent(items, stack, entry.getValue());
                    break;
                }
                case "hostile": {
                    if (!(entity instanceof Monster) || entity.getType().is(Tags.EntityTypes.BOSSES) && !(entity instanceof Warden)) break;
                    DropHandler.addWithPercent(items, stack, entry.getValue());
                    break;
                }
                case "boss": {
                    if (!entity.getType().is(Tags.EntityTypes.BOSSES) || entity instanceof EnderDragon) break;
                    DropHandler.addWithPercent(items, stack, entry.getValue());
                    break;
                }
                case "dragon": {
                    if (!(entity instanceof EnderDragon)) break;
                    DropHandler.addWithPercent(items, stack, entry.getValue());
                }
            }
        }
    }

    public static void addWithPercent(List<ItemStack> list, ItemStack stack, double percentage) {
        Random random = new Random();
        int percent = (int)(percentage * 100.0);
        if (random.nextInt(100) < percent) {
            list.add(stack);
        }
    }
}

