/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.items;

import com.traverse.bhc.common.BaubleyHeartCanisters;
import com.traverse.bhc.common.config.BHCConfig;
import com.traverse.bhc.common.items.BaseItem;
import com.traverse.bhc.common.util.HeartType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemHeart
extends BaseItem {
    protected final HeartType type;

    public ItemHeart(HeartType type) {
        this.type = type;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 30;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand hand) {
        playerIn.startUsingItem(hand);
        return InteractionResultHolder.sidedSuccess((Object)playerIn.getItemInHand(hand), (boolean)level.isClientSide());
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        if (!worldIn.isClientSide()) {
            Player player;
            entityLiving.heal((float)this.type.healAmount);
            if (!(entityLiving instanceof Player) || !(player = (Player)entityLiving).isCreative()) {
                stack.shrink(1);
            }
            if (entityLiving instanceof ServerPlayer) {
                player = (ServerPlayer)entityLiving;
                player.resetSentInfo();
            }
        }
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        BHCConfig config = BaubleyHeartCanisters.config;
        if (config == null) {
            return;
        }
        String heartTypeKey = this.getHeartTypeKey();
        Map<String, Double> entries = config.getHeartTypeEntries(heartTypeKey);
        if (entries == null || entries.isEmpty()) {
            return;
        }
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.empty());
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.bhc.heart_drops").withStyle(ChatFormatting.GOLD));
            for (Map.Entry<String, Double> entry : entries.entrySet()) {
                String entityKey = entry.getKey();
                double chance = entry.getValue();
                int percentage = (int)(chance * 100.0);
                Component entityDisplayName = this.getEntityDisplayName(entityKey, context);
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.bhc.drop_info", (Object[])new Object[]{entityDisplayName, percentage}).withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.bhc.hold_shift_for_drops").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    private String getHeartTypeKey() {
        return switch (this.type) {
            case HeartType.RED -> "red";
            case HeartType.YELLOW -> "yellow";
            case HeartType.GREEN -> "green";
            case HeartType.BLUE -> "blue";
            default -> "";
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @OnlyIn(value=Dist.CLIENT)
    private Component getEntityDisplayName(String entityKey, Item.TooltipContext context) {
        MutableComponent mutableComponent;
        switch (entityKey) {
            case "passive": {
                MutableComponent mutableComponent2;
                mutableComponent = mutableComponent2 = Component.translatable((String)"entity.bhc.passive_mobs");
                return mutableComponent;
            }
            case "hostile": {
                MutableComponent mutableComponent3;
                mutableComponent = mutableComponent3 = Component.translatable((String)"entity.bhc.hostile_mobs");
                return mutableComponent;
            }
            case "boss": {
                MutableComponent mutableComponent4;
                mutableComponent = mutableComponent4 = Component.translatable((String)"entity.bhc.boss_mobs");
                return mutableComponent;
            }
            case "dragon": {
                Component component = EntityType.ENDER_DRAGON.getDescription();
                mutableComponent = component;
                return mutableComponent;
            }
        }
        try {
            MutableComponent mutableComponent5;
            String namePart;
            Object formatted;
            ResourceLocation entityId = ResourceLocation.parse((String)entityKey);
            Optional entityRegistry = context.registries().lookup(Registries.ENTITY_TYPE);
            if (entityRegistry.isPresent()) {
                ResourceKey entityTypeKey = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)entityId);
                Optional entityTypeHolder = ((HolderLookup.RegistryLookup)entityRegistry.get()).get(entityTypeKey);
                if (entityTypeHolder.isPresent()) {
                    Component component = ((EntityType)((Holder.Reference)entityTypeHolder.get()).value()).getDescription();
                    mutableComponent = component;
                    return mutableComponent;
                }
            }
            if (!((String)(formatted = (namePart = entityKey.contains(":") ? entityKey.split(":")[1] : entityKey).replace("_", " "))).isEmpty()) {
                formatted = ((String)formatted).substring(0, 1).toUpperCase() + ((String)formatted).substring(1).toLowerCase();
            }
            mutableComponent = mutableComponent5 = Component.literal((String)formatted);
            return mutableComponent;
        }
        catch (Exception e) {
            MutableComponent mutableComponent6;
            mutableComponent = mutableComponent6 = Component.literal((String)entityKey);
            return mutableComponent;
        }
    }
}

