/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.bonus;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.effect.MobEffectAffix;
import dev.shadowsoffire.apotheosis.mixin.LivingEntityInvoker;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class MobEffectBonus
extends GemBonus {
    public static final Codec<MobEffectBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(MobEffectBonus.gemClass(), (App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("mob_effect").forGetter(a -> a.effect), (App)MobEffectAffix.Target.CODEC.fieldOf("target").forGetter(a -> a.target), (App)Purity.mapCodec(EffectData.CODEC).fieldOf("values").forGetter(a -> a.values), (App)Codec.BOOL.optionalFieldOf("stack_on_reapply", (Object)false).forGetter(a -> a.stackOnReapply), (App)Codec.intRange((int)1, (int)255).optionalFieldOf("stacking_limit", (Object)255).forGetter(a -> a.stackingLimit)).apply((Applicative)inst, MobEffectBonus::new));
    protected final Holder<MobEffect> effect;
    protected final MobEffectAffix.Target target;
    protected final Map<Purity, EffectData> values;
    protected final boolean stackOnReapply;
    protected final int stackingLimit;

    public MobEffectBonus(GemClass gemClass, Holder<MobEffect> effect, MobEffectAffix.Target target, Map<Purity, EffectData> values, boolean stackOnReapply, int stackingLimit) {
        super(gemClass);
        this.effect = effect;
        this.target = target;
        this.values = values;
        this.stackOnReapply = stackOnReapply;
        this.stackingLimit = stackingLimit;
    }

    @Override
    public Component getSocketBonusTooltip(GemView gem, AttributeTooltipContext ctx) {
        MobEffectInstance inst = this.values.get(gem.purity()).build(this.effect);
        MutableComponent comp = this.target.toComponent(MobEffectBonus.toComponent(inst, ctx.tickRate())).withStyle(ChatFormatting.YELLOW);
        int cooldown = this.getCooldown(gem.purity());
        if (cooldown != 0) {
            MutableComponent cd = Component.translatable((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.formatTickDuration((int)cooldown, (float)ctx.tickRate())});
            comp = comp.append(" ").append((Component)cd);
        }
        if (this.stackOnReapply) {
            comp = comp.append(" ").append((Component)Component.translatable((String)"affix.apotheosis.stacking"));
        }
        return comp;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public boolean supports(Purity purity) {
        return this.values.containsKey(purity);
    }

    @Override
    public void doPostHurt(GemInstance inst, LivingEntity user, DamageSource source) {
        Entity entity;
        if (this.target == MobEffectAffix.Target.HURT_SELF) {
            this.applyEffect(inst, user);
        } else if (this.target == MobEffectAffix.Target.HURT_ATTACKER && (entity = source.getEntity()) instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)entity;
            this.applyEffect(inst, tLiving);
        }
    }

    @Override
    public void doPostAttack(GemInstance inst, LivingEntity user, Entity target) {
        if (this.target == MobEffectAffix.Target.ATTACK_SELF) {
            this.applyEffect(inst, user);
        } else if (this.target == MobEffectAffix.Target.ATTACK_TARGET && target instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)target;
            this.applyEffect(inst, tLiving);
        }
    }

    @Override
    public void onBlockBreak(GemInstance inst, Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        if (this.target == MobEffectAffix.Target.BREAK_SELF) {
            this.applyEffect(inst, (LivingEntity)player);
        }
    }

    @Override
    public void onProjectileImpact(GemInstance inst, Projectile proj, HitResult res) {
        Entity entity;
        if (res.getType() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)res).getEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            switch (this.target) {
                case ARROW_SELF: {
                    Entity entity2;
                    if (!(proj instanceof AbstractArrow) || !((entity2 = proj.getOwner()) instanceof LivingEntity)) break;
                    LivingEntity owner = (LivingEntity)entity2;
                    this.applyEffect(inst, owner);
                    break;
                }
                case ARROW_TARGET: {
                    if (!(proj instanceof AbstractArrow)) break;
                    this.applyEffect(inst, target);
                    break;
                }
                case PROJECTILE_SELF: {
                    Entity entity3 = proj.getOwner();
                    if (!(entity3 instanceof LivingEntity)) break;
                    LivingEntity owner = (LivingEntity)entity3;
                    this.applyEffect(inst, owner);
                    break;
                }
                case PROJECTILE_TARGET: {
                    this.applyEffect(inst, target);
                    break;
                }
            }
        }
    }

    @Override
    public float onShieldBlock(GemInstance inst, LivingEntity entity, DamageSource source, float amount) {
        Entity entity2;
        if (this.target == MobEffectAffix.Target.BLOCK_SELF) {
            this.applyEffect(inst, entity);
        } else if (this.target == MobEffectAffix.Target.BLOCK_ATTACKER && (entity2 = source.getDirectEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity2;
            this.applyEffect(inst, target);
        }
        return amount;
    }

    protected int getCooldown(Purity purity) {
        EffectData data = this.values.get(purity);
        return data.cooldown;
    }

    private void applyEffect(GemInstance inst, LivingEntity target) {
        int cooldown = this.getCooldown(inst.purity());
        if (cooldown != 0 && Affix.isOnCooldown(MobEffectBonus.makeUniqueId(inst), cooldown, target)) {
            return;
        }
        EffectData data = this.values.get(inst.purity());
        MobEffectInstance effectInst = target.getEffect(this.effect);
        if (this.stackOnReapply && effectInst != null) {
            if (inst != null) {
                int duration = Math.max(effectInst.getDuration(), data.duration);
                int amp = Math.min(this.stackingLimit, effectInst.getAmplifier() + 1 + data.amplifier);
                MobEffectInstance newInst = new MobEffectInstance(this.effect, duration, amp, effectInst.isAmbient(), effectInst.isVisible());
                effectInst.update(newInst);
                ((LivingEntityInvoker)target).callOnEffectUpdated(effectInst, true, null);
                effectInst.onEffectStarted(target);
            }
        } else {
            target.addEffect(data.build(this.effect));
        }
        Affix.startCooldown(MobEffectBonus.makeUniqueId(inst), target);
    }

    public static Component toComponent(MobEffectInstance inst, float tickRate) {
        MutableComponent mutablecomponent = Component.translatable((String)inst.getDescriptionId());
        Holder mobeffect = inst.getEffect();
        if (inst.getAmplifier() > 0) {
            mutablecomponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.translatable((String)("potion.potency." + inst.getAmplifier()))});
        }
        if (inst.getDuration() > 20) {
            mutablecomponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.formatDuration((MobEffectInstance)inst, (float)1.0f, (float)tickRate)});
        }
        return mutablecomponent.withStyle(((MobEffect)mobeffect.value()).getCategory().getTooltipFormatting());
    }

    public static Builder builder() {
        return new Builder();
    }

    public record EffectData(int duration, int amplifier, int cooldown) {
        private static Codec<EffectData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("duration").forGetter(EffectData::duration), (App)Codec.INT.fieldOf("amplifier").forGetter(EffectData::amplifier), (App)Codec.INT.optionalFieldOf("cooldown", (Object)0).forGetter(EffectData::cooldown)).apply((Applicative)inst, EffectData::new));

        public MobEffectInstance build(Holder<MobEffect> effect) {
            return new MobEffectInstance(effect, this.duration, this.amplifier);
        }

        public MobEffectInstance buildStacking(Holder<MobEffect> effect, int existingAmp) {
            return new MobEffectInstance(effect, this.duration, this.amplifier + existingAmp);
        }
    }

    public static class Builder
    extends GemBonus.Builder {
        private final Map<Purity, EffectData> values = new HashMap<Purity, EffectData>();
        private Holder<MobEffect> effect;
        private MobEffectAffix.Target target;
        private boolean stacking = false;
        private int limit = 255;

        public Builder effect(Holder<MobEffect> effect) {
            this.effect = effect;
            return this;
        }

        public Builder target(MobEffectAffix.Target target) {
            this.target = target;
            return this;
        }

        public Builder value(Purity purity, int duration, int amplifier) {
            return this.value(purity, duration, amplifier, 0);
        }

        public Builder value(Purity purity, int duration, int amplifier, int cooldown) {
            return this.value(purity, new EffectData(duration, amplifier, cooldown));
        }

        public Builder value(Purity purity, EffectData value) {
            this.values.put(purity, value);
            return this;
        }

        public Builder stacking() {
            this.stacking = true;
            return this;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public MobEffectBonus build(GemClass gemClass) {
            return new MobEffectBonus(gemClass, this.effect, this.target, this.values, this.stacking, this.limit);
        }
    }
}

