/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_attributes.api.AttributeHelper;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class AffixCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_AFFIX = (ctx, builder) -> SharedSuggestionProvider.suggest(AffixRegistry.INSTANCE.getKeys().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_APPLICABLE_AFFIX = (ctx, builder) -> {
        LivingEntity living;
        ItemStack held;
        Entity entity = ((CommandSourceStack)ctx.getSource()).getEntity();
        if (entity instanceof LivingEntity && !(held = (living = (LivingEntity)entity).getMainHandItem()).isEmpty()) {
            LootCategory cat = LootCategory.forItem(held);
            DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(held);
            if (!cat.isNone() && rarity.isBound()) {
                Stream<String> suggestions = AffixRegistry.INSTANCE.getValues().stream().filter(a -> a.canApplyTo(held, cat, (LootRarity)rarity.get())).map(arg_0 -> ((AffixRegistry)AffixRegistry.INSTANCE).getKey(arg_0)).map(ResourceLocation::toString);
                return SharedSuggestionProvider.suggest(suggestions, (SuggestionsBuilder)builder);
            }
        }
        return SharedSuggestionProvider.suggest(Collections.emptyList(), (SuggestionsBuilder)builder);
    };
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_AFFIX_ON_ITEM = (ctx, builder) -> {
        LivingEntity living;
        ItemStack held;
        Entity entity = ((CommandSourceStack)ctx.getSource()).getEntity();
        if (entity instanceof LivingEntity && !(held = (living = (LivingEntity)entity).getMainHandItem()).isEmpty()) {
            Map<DynamicHolder<Affix>, AffixInstance> affixes = AffixHelper.getAffixes(held);
            return SharedSuggestionProvider.suggest(affixes.keySet().stream().map(DynamicHolder::getId).map(ResourceLocation::toString), (SuggestionsBuilder)builder);
        }
        return SharedSuggestionProvider.suggest(Collections.emptyList(), (SuggestionsBuilder)builder);
    };

    public static void register(LiteralArgumentBuilder<CommandSourceStack> root) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"affix").requires(c -> c.hasPermission(2));
        builder.then(Commands.literal((String)"apply").then(((RequiredArgumentBuilder)Commands.argument((String)"affix", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_APPLICABLE_AFFIX).then(Commands.argument((String)"level", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(c -> AffixCommand.applyAffix((CommandContext<CommandSourceStack>)c, ResourceLocationArgument.getId((CommandContext)c, (String)"affix"), FloatArgumentType.getFloat((CommandContext)c, (String)"level"))))).executes(c -> AffixCommand.applyAffix((CommandContext<CommandSourceStack>)c, ResourceLocationArgument.getId((CommandContext)c, (String)"affix"), ((CommandSourceStack)c.getSource()).getLevel().random.nextFloat()))));
        builder.then(Commands.literal((String)"list").executes(AffixCommand::listAffixes));
        builder.then(Commands.literal((String)"list_alternatives").then(Commands.argument((String)"affix", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_AFFIX_ON_ITEM).executes(c -> AffixCommand.listAlternatives((CommandContext<CommandSourceStack>)c, ResourceLocationArgument.getId((CommandContext)c, (String)"affix")))));
        root.then((ArgumentBuilder)builder);
    }

    public static int applyAffix(CommandContext<CommandSourceStack> c, ResourceLocation affixId, float level) {
        DynamicHolder afx = AffixRegistry.INSTANCE.holder(affixId);
        if (!afx.isBound()) {
            return AffixCommand.fail(c, "Unknown affix: " + String.valueOf(affixId), -1);
        }
        Entity entity = ((CommandSourceStack)c.getSource()).getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ItemStack held = living.getMainHandItem();
            if (held.isEmpty()) {
                return AffixCommand.fail(c, "The target entity must have an item in their main hand.", -2);
            }
            DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(held);
            if (!rarity.isBound()) {
                return AffixCommand.fail(c, "The target item must have a set rarity.", -3);
            }
            LootCategory cat = LootCategory.forItem(held);
            if (cat.isNone()) {
                return AffixCommand.fail(c, "The target item must have a valid loot category", -4);
            }
            if (!((Affix)afx.get()).canApplyTo(held, cat, (LootRarity)rarity.get())) {
                return AffixCommand.fail(c, "The selected affix cannot be applied to the target item.", -5);
            }
            AffixHelper.applyAffix(held, new AffixInstance((DynamicHolder<Affix>)afx, level, rarity, held));
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.translatable((String)"Successfully applied affix %s with level %s to %s", (Object[])new Object[]{affixId.toString(), Float.valueOf(level), held.getDisplayName()}), true);
            return 0;
        }
        return AffixCommand.fail(c, "/apoth affix must be executed by a living entity.", -10);
    }

    public static int listAffixes(CommandContext<CommandSourceStack> c) {
        Entity entity = ((CommandSourceStack)c.getSource()).getEntity();
        if (entity instanceof LivingEntity) {
            Player p;
            LivingEntity living = (LivingEntity)entity;
            ItemStack held = living.getMainHandItem();
            if (held.isEmpty()) {
                return AffixCommand.fail(c, "The target entity must have an item in their main hand.", -2);
            }
            DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(held);
            if (!rarity.isBound()) {
                return AffixCommand.fail(c, "The target item must have a set rarity.", -3);
            }
            Map<DynamicHolder<Affix>, AffixInstance> affixes = AffixHelper.getAffixes(held);
            AttributeTooltipContext ctx = AttributeTooltipContext.of((Player)(living instanceof Player ? (p = (Player)living) : null), (Item.TooltipContext)Item.TooltipContext.of((Level)((CommandSourceStack)c.getSource()).getLevel()), (TooltipFlag)ApothicAttributes.getTooltipFlag());
            ((CommandSourceStack)c.getSource()).sendSystemMessage((Component)Component.translatable((String)"Affixes present on %s:", (Object[])new Object[]{held.getDisplayName()}));
            affixes.forEach((afx, inst) -> {
                MutableComponent name = Component.translatable((String)"[%s]", (Object[])new Object[]{inst.getName(true)});
                name.setStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)inst.getAugmentingText(ctx))));
                ((CommandSourceStack)c.getSource()).sendSystemMessage((Component)Component.translatable((String)"%s - %s%%", (Object[])new Object[]{name, Affix.fmt(100.0f * inst.level())}));
            });
            return 0;
        }
        return AffixCommand.fail(c, "/apoth affix must be executed by a living entity.", -10);
    }

    public static int listAlternatives(CommandContext<CommandSourceStack> c, ResourceLocation affixId) {
        DynamicHolder afx = AffixRegistry.INSTANCE.holder(affixId);
        if (!afx.isBound()) {
            return AffixCommand.fail(c, "Unknown affix: " + String.valueOf(affixId), -1);
        }
        Entity entity = ((CommandSourceStack)c.getSource()).getEntity();
        if (entity instanceof LivingEntity) {
            Player p;
            LivingEntity living = (LivingEntity)entity;
            ItemStack held = living.getMainHandItem();
            if (held.isEmpty()) {
                return AffixCommand.fail(c, "The target entity must have an item in their main hand.", -2);
            }
            DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(held);
            if (!rarity.isBound()) {
                return AffixCommand.fail(c, "The target item must have a set rarity.", -3);
            }
            Map<DynamicHolder<Affix>, AffixInstance> affixes = AffixHelper.getAffixes(held);
            if (!affixes.containsKey(afx)) {
                return AffixCommand.fail(c, "The target item does not contain the selected affix.", -4);
            }
            Stream<DynamicHolder<Affix>> alternatives = LootController.getAlternativeAffixes(held, (LootRarity)rarity.get(), (DynamicHolder<Affix>)afx);
            ((CommandSourceStack)c.getSource()).sendSystemMessage((Component)Component.translatable((String)"Possible alternatives to %s:", (Object[])new Object[]{((Affix)afx.get()).getName(true)}));
            AttributeTooltipContext ctx = AttributeTooltipContext.of((Player)(living instanceof Player ? (p = (Player)living) : null), (Item.TooltipContext)Item.TooltipContext.of((Level)((CommandSourceStack)c.getSource()).getLevel()), (TooltipFlag)ApothicAttributes.getTooltipFlag());
            alternatives.forEach(a -> {
                MutableComponent name = Component.translatable((String)"[%s]", (Object[])new Object[]{((Affix)a.get()).getName(true)});
                AffixInstance inst = new AffixInstance((DynamicHolder<Affix>)a, 0.5f, rarity, held);
                Component augTxt = inst.getAugmentingText(ctx);
                name.setStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)augTxt)));
                ((CommandSourceStack)c.getSource()).sendSystemMessage((Component)AttributeHelper.list().append((Component)name));
            });
            return 0;
        }
        return AffixCommand.fail(c, "/apoth affix must be executed by a living entity.", -10);
    }

    public static int fail(CommandContext<CommandSourceStack> c, String msg, int code) {
        ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.translatable((String)msg));
        return code;
    }
}

