/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.langs.SFMLBaseVisitor;
import ca.teamdman.langs.SFMLParser;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Block;
import ca.teamdman.sfml.ast.BoolConjunction;
import ca.teamdman.sfml.ast.BoolDisjunction;
import ca.teamdman.sfml.ast.BoolExpr;
import ca.teamdman.sfml.ast.BoolFalse;
import ca.teamdman.sfml.ast.BoolHas;
import ca.teamdman.sfml.ast.BoolNegation;
import ca.teamdman.sfml.ast.BoolParen;
import ca.teamdman.sfml.ast.BoolRedstone;
import ca.teamdman.sfml.ast.BoolTrue;
import ca.teamdman.sfml.ast.ComparisonOperator;
import ca.teamdman.sfml.ast.ForgetStatement;
import ca.teamdman.sfml.ast.IfStatement;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Interval;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.Number;
import ca.teamdman.sfml.ast.NumberRange;
import ca.teamdman.sfml.ast.NumberRangeSet;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.ast.ProgramName;
import ca.teamdman.sfml.ast.RedstoneTrigger;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceLimit;
import ca.teamdman.sfml.ast.ResourceLimits;
import ca.teamdman.sfml.ast.ResourceQuantity;
import ca.teamdman.sfml.ast.RoundRobin;
import ca.teamdman.sfml.ast.SetOperator;
import ca.teamdman.sfml.ast.Side;
import ca.teamdman.sfml.ast.SideQualifier;
import ca.teamdman.sfml.ast.Statement;
import ca.teamdman.sfml.ast.StringHolder;
import ca.teamdman.sfml.ast.TagMatcher;
import ca.teamdman.sfml.ast.TimerTrigger;
import ca.teamdman.sfml.ast.Trigger;
import ca.teamdman.sfml.ast.With;
import ca.teamdman.sfml.ast.WithClause;
import ca.teamdman.sfml.ast.WithConjunction;
import ca.teamdman.sfml.ast.WithDisjunction;
import ca.teamdman.sfml.ast.WithNegation;
import ca.teamdman.sfml.ast.WithParen;
import ca.teamdman.sfml.ast.WithTag;
import com.mojang.datafixers.util.Pair;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jetbrains.annotations.Nullable;

public class ASTBuilder
extends SFMLBaseVisitor<ASTNode> {
    private final Set<Label> USED_LABELS = new HashSet<Label>();
    private final Set<ResourceIdentifier<?, ?, ?>> USED_RESOURCES = new HashSet();
    private final List<Pair<WeakReference<ASTNode>, ParserRuleContext>> AST_NODE_CONTEXTS = new LinkedList<Pair<WeakReference<ASTNode>, ParserRuleContext>>();

    public List<Pair<ASTNode, ParserRuleContext>> getNodesUnderCursor(int cursorPos) {
        return this.AST_NODE_CONTEXTS.stream().filter(pair -> pair.getSecond() != null).filter(pair -> ((ParserRuleContext)pair.getSecond()).start.getStartIndex() <= cursorPos && ((ParserRuleContext)pair.getSecond()).stop.getStopIndex() >= cursorPos).map(pair -> Pair.of((Object)((ASTNode)((WeakReference)pair.getFirst()).get()), (Object)((ParserRuleContext)pair.getSecond()))).filter(pair -> pair.getFirst() != null).collect(Collectors.toList());
    }

    public Optional<ASTNode> getNodeAtIndex(int index) {
        if (index < 0 || index >= this.AST_NODE_CONTEXTS.size()) {
            return Optional.empty();
        }
        WeakReference nodeRef = (WeakReference)this.AST_NODE_CONTEXTS.get(index).getFirst();
        return Optional.ofNullable((ASTNode)nodeRef.get());
    }

    public void setLocationFromOtherNode(ASTNode node, ASTNode otherNode) {
        this.trackNode(node, (ParserRuleContext)this.AST_NODE_CONTEXTS.get(this.getIndexForNode(otherNode)).getSecond());
    }

    public int getIndexForNode(ASTNode node) {
        for (int i = 0; i < this.AST_NODE_CONTEXTS.size(); ++i) {
            Pair<WeakReference<ASTNode>, ParserRuleContext> pair = this.AST_NODE_CONTEXTS.get(i);
            if (((WeakReference)pair.getFirst()).get() != node) continue;
            return i;
        }
        return -1;
    }

    public Optional<ParserRuleContext> getContextForNode(ASTNode node) {
        return this.AST_NODE_CONTEXTS.stream().filter(pair -> ((WeakReference)pair.getFirst()).get() == node).map(Pair::getSecond).findFirst();
    }

    public String getLineColumnForNode(ASTNode node) {
        return this.getContextForNode(node).map(ctx -> "Line " + ctx.start.getLine() + ", Column " + ctx.start.getCharPositionInLine()).orElse("Unknown location");
    }

    @Override
    public StringHolder visitName(@Nullable SFMLParser.NameContext ctx) {
        if (ctx == null) {
            return new StringHolder("");
        }
        StringHolder name = this.visitString(ctx.string());
        this.trackNode(new ProgramName(name), ctx);
        return name;
    }

    @Override
    public ASTNode visitResource(SFMLParser.ResourceContext ctx) {
        String str = ctx.children.stream().map(ParseTree::getText).collect(Collectors.joining()).replaceAll("::", ":*:").replaceAll(":$", ":*").replaceAll("\\*", ".*").toLowerCase(Locale.ROOT);
        ResourceIdentifier rtn = ResourceIdentifier.fromString(str);
        this.USED_RESOURCES.add(rtn);
        rtn.assertValid();
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public ResourceIdentifier<?, ?, ?> visitStringResource(SFMLParser.StringResourceContext ctx) {
        ResourceIdentifier rtn = ResourceIdentifier.fromString(this.visitString(ctx.string()).value());
        this.USED_RESOURCES.add(rtn);
        rtn.assertValid();
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public StringHolder visitString(SFMLParser.StringContext ctx) {
        String content = ctx.getText();
        String innerContent = content.substring(1, content.length() - 1).replaceAll("\\\\\"", "\"");
        StringHolder str = new StringHolder(innerContent);
        this.trackNode(str, ctx);
        return str;
    }

    @Override
    public Label visitRawLabel(SFMLParser.RawLabelContext ctx) {
        Label label = new Label(ctx.getText());
        if (label.name().length() > 256) {
            throw new IllegalArgumentException("Label name cannot be longer than 256 characters.");
        }
        this.USED_LABELS.add(label);
        this.trackNode(label, ctx);
        return label;
    }

    @Override
    public Label visitStringLabel(SFMLParser.StringLabelContext ctx) {
        Label label = new Label(this.visitString(ctx.string()).value());
        if (label.name().length() > 256) {
            throw new IllegalArgumentException("Label name cannot be longer than 256 characters.");
        }
        this.USED_LABELS.add(label);
        this.trackNode(label, ctx);
        return label;
    }

    @Override
    public Program visitProgram(SFMLParser.ProgramContext ctx) {
        if (((Boolean)SFMConfig.getOrDefault(SFMConfig.SERVER_CONFIG.disableProgramExecution)).booleanValue()) {
            throw new AssertionError((Object)"Program execution is disabled via config");
        }
        StringHolder name = this.visitName(ctx.name());
        List<Trigger> triggers = ctx.trigger().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(Trigger.class::cast).collect(Collectors.toList());
        Set<String> labels = this.USED_LABELS.stream().map(Label::name).collect(Collectors.toSet());
        Program program = new Program(this, name.value(), triggers, labels, this.USED_RESOURCES);
        this.trackNode(program, ctx);
        return program;
    }

    @Override
    public ASTNode visitTimerTrigger(SFMLParser.TimerTriggerContext ctx) {
        int minInterval;
        Block block;
        Interval time = (Interval)this.visit((ParseTree)ctx.interval());
        TimerTrigger timerTrigger = new TimerTrigger(time, block = this.visitBlock(ctx.block()));
        int n = minInterval = timerTrigger.usesOnlyForgeEnergyResourceIO() ? ((Integer)SFMConfig.getOrDefault(SFMConfig.SERVER_CONFIG.timerTriggerMinimumIntervalInTicksWhenOnlyForgeEnergyIO)).intValue() : ((Integer)SFMConfig.getOrDefault(SFMConfig.SERVER_CONFIG.timerTriggerMinimumIntervalInTicks)).intValue();
        if (time.ticks() < minInterval) {
            throw new IllegalArgumentException("Minimum trigger interval is " + minInterval + " ticks.");
        }
        this.trackNode(timerTrigger, ctx);
        return timerTrigger;
    }

    @Override
    public ASTNode visitBooleanRedstone(SFMLParser.BooleanRedstoneContext ctx) {
        ComparisonOperator comp = ComparisonOperator.GREATER_OR_EQUAL;
        Number num = new Number(0L);
        if (ctx.comparisonOp() != null && ctx.number() != null) {
            comp = this.visitComparisonOp(ctx.comparisonOp());
            num = this.visitNumber(ctx.number());
        }
        if (num.value() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Redstone signal strength cannot be greater than 2147483647");
        }
        BoolRedstone boolExpr = new BoolRedstone(comp, (int)num.value());
        this.trackNode(boolExpr, ctx);
        return boolExpr;
    }

    @Override
    public ASTNode visitPulseTrigger(SFMLParser.PulseTriggerContext ctx) {
        Block block = this.visitBlock(ctx.block());
        RedstoneTrigger redstoneTrigger = new RedstoneTrigger(block);
        this.trackNode(redstoneTrigger, ctx);
        return redstoneTrigger;
    }

    @Override
    public Number visitNumber(SFMLParser.NumberContext ctx) {
        Number number = new Number(Long.parseLong(ctx.getText()));
        this.trackNode(number, ctx);
        return number;
    }

    @Override
    public ASTNode visitIntervalSpace(SFMLParser.IntervalSpaceContext ctx) {
        TerminalNode firstNumber = ctx.NUMBER(0);
        int ticks = firstNumber == null ? 1 : Integer.parseInt(firstNumber.getText());
        if (ctx.SECONDS() != null || ctx.SECOND() != null) {
            ticks *= 20;
        }
        Interval.IntervalAlignment alignment = Interval.IntervalAlignment.LOCAL;
        if (ctx.GLOBAL() != null) {
            alignment = Interval.IntervalAlignment.GLOBAL;
        }
        int offset = 0;
        TerminalNode secondNumber = ctx.NUMBER(1);
        if (secondNumber != null) {
            offset = Integer.parseInt(secondNumber.getText());
            if (ctx.SECONDS() != null || ctx.SECOND() != null) {
                offset *= 20;
            }
        }
        Interval interval = new Interval(ticks, alignment, offset);
        this.trackNode(interval, ctx);
        return interval;
    }

    @Override
    public ASTNode visitIntervalNoSpace(SFMLParser.IntervalNoSpaceContext ctx) {
        String firstNumber = ctx.NUMBER_WITH_G_SUFFIX().getText();
        String front = firstNumber.substring(0, firstNumber.length() - 1);
        int ticks = Integer.parseInt(front);
        if (ctx.SECONDS() != null || ctx.SECOND() != null) {
            ticks *= 20;
        }
        Interval.IntervalAlignment alignment = Interval.IntervalAlignment.GLOBAL;
        int offset = 0;
        TerminalNode secondNumber = ctx.NUMBER();
        if (secondNumber != null) {
            offset = Integer.parseInt(secondNumber.getText());
            if (ctx.SECONDS() != null || ctx.SECOND() != null) {
                offset *= 20;
            }
        }
        Interval interval = new Interval(ticks, alignment, offset);
        this.trackNode(interval, ctx);
        return interval;
    }

    @Override
    public InputStatement visitInputStatement(SFMLParser.InputStatementContext ctx) {
        LabelAccess labelAccess = this.visitLabelAccess(ctx.labelAccess());
        ResourceLimits matchers = this.visitInputResourceLimits(ctx.inputResourceLimits());
        ResourceIdSet exclusions = this.visitResourceExclusion(ctx.resourceExclusion());
        boolean each = ctx.EACH() != null;
        InputStatement inputStatement = new InputStatement(labelAccess, matchers.withExclusions(exclusions), each);
        this.trackNode(inputStatement, ctx);
        return inputStatement;
    }

    @Override
    public OutputStatement visitOutputStatement(SFMLParser.OutputStatementContext ctx) {
        LabelAccess labelAccess = this.visitLabelAccess(ctx.labelAccess());
        ResourceLimits matchers = this.visitOutputResourceLimits(ctx.outputResourceLimits());
        ResourceIdSet exclusions = this.visitResourceExclusion(ctx.resourceExclusion());
        boolean each = ctx.EACH() != null;
        boolean emptySlotsOnly = ctx.emptyslots() != null;
        OutputStatement outputStatement = new OutputStatement(labelAccess, matchers.withExclusions(exclusions), each, emptySlotsOnly);
        this.trackNode(outputStatement, ctx);
        return outputStatement;
    }

    @Override
    public LabelAccess visitLabelAccess(SFMLParser.LabelAccessContext ctx) {
        SFMLParser.SidequalifierContext directionQualifierCtx = ctx.sidequalifier();
        SideQualifier sideQualifier = directionQualifierCtx == null ? SideQualifier.NULL : (SideQualifier)this.visit((ParseTree)directionQualifierCtx);
        LabelAccess labelAccess = new LabelAccess(ctx.label().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(Label.class::cast).collect(Collectors.toList()), sideQualifier, this.visitSlotqualifier(ctx.slotqualifier()), this.visitRoundrobin(ctx.roundrobin()));
        this.trackNode(labelAccess, ctx);
        return labelAccess;
    }

    @Override
    public RoundRobin visitRoundrobin(@Nullable SFMLParser.RoundrobinContext ctx) {
        if (ctx == null) {
            return RoundRobin.disabled();
        }
        RoundRobin rtn = ctx.BLOCK() != null ? new RoundRobin(RoundRobin.Behaviour.BY_BLOCK) : new RoundRobin(RoundRobin.Behaviour.BY_LABEL);
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public IfStatement visitIfStatement(SFMLParser.IfStatementContext ctx) {
        IfStatement nestedStatement;
        ArrayDeque conditions = ctx.boolexpr().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(BoolExpr.class::cast).collect(Collectors.toCollection(ArrayDeque::new));
        ArrayDeque blocks = ctx.block().stream().map(this::visitBlock).collect(Collectors.toCollection(ArrayDeque::new));
        if (conditions.size() < blocks.size()) {
            Block elseBlock = (Block)blocks.removeLast();
            Block ifBlock = (Block)blocks.removeLast();
            nestedStatement = new IfStatement((BoolExpr)conditions.removeLast(), ifBlock, elseBlock);
        } else {
            nestedStatement = new IfStatement((BoolExpr)conditions.removeLast(), (Block)blocks.removeLast(), new Block(List.of()));
        }
        while (!blocks.isEmpty()) {
            nestedStatement = new IfStatement((BoolExpr)conditions.removeLast(), (Block)blocks.removeLast(), new Block(List.of(nestedStatement)));
        }
        if (!conditions.isEmpty()) {
            throw new IllegalStateException("If statement construction failed to consume all conditions");
        }
        this.trackNode(nestedStatement, ctx);
        return nestedStatement;
    }

    @Override
    public BoolExpr visitBooleanHas(SFMLParser.BooleanHasContext ctx) {
        SetOperator setOperator = this.visitSetOp(ctx.setOp());
        LabelAccess labelAccess = this.visitLabelAccess(ctx.labelAccess());
        ComparisonOperator comparisonOperator = this.visitComparisonOp(ctx.comparisonOp());
        Number num = this.visitNumber(ctx.number());
        ResourceIdSet resourceIdSet = ctx.resourceIdDisjunction() == null ? ResourceIdSet.MATCH_ALL : this.visitResourceIdDisjunction(ctx.resourceIdDisjunction());
        With with = ctx.with() == null ? With.ALWAYS_TRUE : (With)this.visit((ParseTree)ctx.with());
        ResourceIdSet except = ctx.resourceIdList() == null ? ResourceIdSet.EMPTY : this.visitResourceIdList(ctx.resourceIdList());
        BoolHas rtn = new BoolHas(setOperator, labelAccess, comparisonOperator, num.value(), resourceIdSet, with, except);
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public SetOperator visitSetOp(@Nullable SFMLParser.SetOpContext ctx) {
        if (ctx == null) {
            return SetOperator.OVERALL;
        }
        SetOperator from = SetOperator.from(ctx.getText());
        this.trackNode(from, ctx);
        return from;
    }

    @Override
    public ComparisonOperator visitComparisonOp(SFMLParser.ComparisonOpContext ctx) {
        ComparisonOperator from = ComparisonOperator.from(ctx.getText());
        this.trackNode(from, ctx);
        return from;
    }

    @Override
    public BoolExpr visitBooleanTrue(SFMLParser.BooleanTrueContext ctx) {
        BoolTrue rtn = new BoolTrue();
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public BoolExpr visitBooleanFalse(SFMLParser.BooleanFalseContext ctx) {
        BoolFalse rtn = new BoolFalse();
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public BoolExpr visitBooleanParen(SFMLParser.BooleanParenContext ctx) {
        BoolParen rtn = new BoolParen((BoolExpr)this.visit((ParseTree)ctx.boolexpr()));
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public BoolExpr visitBooleanNegation(SFMLParser.BooleanNegationContext ctx) {
        BoolNegation rtn = new BoolNegation((BoolExpr)this.visit((ParseTree)ctx.boolexpr()));
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public BoolExpr visitBooleanConjunction(SFMLParser.BooleanConjunctionContext ctx) {
        BoolExpr left = (BoolExpr)this.visit((ParseTree)ctx.boolexpr(0));
        BoolExpr right = (BoolExpr)this.visit((ParseTree)ctx.boolexpr(1));
        BoolConjunction rtn = new BoolConjunction(left, right);
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public BoolExpr visitBooleanDisjunction(SFMLParser.BooleanDisjunctionContext ctx) {
        BoolExpr left = (BoolExpr)this.visit((ParseTree)ctx.boolexpr(0));
        BoolExpr right = (BoolExpr)this.visit((ParseTree)ctx.boolexpr(1));
        BoolDisjunction rtn = new BoolDisjunction(left, right);
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public Limit visitQuantityRetentionLimit(SFMLParser.QuantityRetentionLimitContext ctx) {
        ResourceQuantity quantity = this.visitQuantity(ctx.quantity());
        ResourceQuantity retain = this.visitRetention(ctx.retention());
        Limit limit = new Limit(quantity, retain);
        this.trackNode(limit, ctx);
        return limit;
    }

    @Override
    public ResourceIdSet visitResourceExclusion(@Nullable SFMLParser.ResourceExclusionContext ctx) {
        if (ctx == null) {
            return ResourceIdSet.EMPTY;
        }
        ResourceIdSet resourceIdSet = this.visitResourceIdList(ctx.resourceIdList());
        this.trackNode(resourceIdSet, ctx);
        return resourceIdSet;
    }

    @Override
    public ResourceIdSet visitResourceIdList(@Nullable SFMLParser.ResourceIdListContext ctx) {
        if (ctx == null) {
            return ResourceIdSet.EMPTY;
        }
        HashSet ids = ctx.resourceId().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(ResourceIdentifier.class::cast).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        ResourceIdSet resourceIdSet = new ResourceIdSet(ids);
        this.trackNode(resourceIdSet, ctx);
        return resourceIdSet;
    }

    @Override
    public ResourceIdSet visitResourceIdDisjunction(@Nullable SFMLParser.ResourceIdDisjunctionContext ctx) {
        if (ctx == null) {
            return ResourceIdSet.EMPTY;
        }
        HashSet ids = ctx.resourceId().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(ResourceIdentifier.class::cast).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        ResourceIdSet resourceIdSet = new ResourceIdSet(ids);
        this.trackNode(resourceIdSet, ctx);
        return resourceIdSet;
    }

    @Override
    public ResourceLimits visitInputResourceLimits(@Nullable SFMLParser.InputResourceLimitsContext ctx) {
        if (ctx == null) {
            return new ResourceLimits(List.of(ResourceLimit.TAKE_ALL_LEAVE_NONE), ResourceIdSet.EMPTY);
        }
        ResourceLimits resourceLimits = this.visitResourceLimitList(ctx.resourceLimitList()).withDefaultLimit(Limit.MAX_QUANTITY_NO_RETENTION);
        this.trackNode(resourceLimits, ctx);
        return resourceLimits;
    }

    @Override
    public ResourceLimits visitOutputResourceLimits(@Nullable SFMLParser.OutputResourceLimitsContext ctx) {
        if (ctx == null) {
            return new ResourceLimits(List.of(ResourceLimit.ACCEPT_ALL_WITHOUT_RESTRAINT), ResourceIdSet.EMPTY);
        }
        ResourceLimits resourceLimits = this.visitResourceLimitList(ctx.resourceLimitList()).withDefaultLimit(Limit.MAX_QUANTITY_MAX_RETENTION);
        this.trackNode(resourceLimits, ctx);
        return resourceLimits;
    }

    @Override
    public ResourceLimits visitResourceLimitList(SFMLParser.ResourceLimitListContext ctx) {
        ResourceLimits resourceLimits = new ResourceLimits(ctx.resourceLimit().stream().map(this::visitResourceLimit).collect(Collectors.toList()), ResourceIdSet.EMPTY);
        this.trackNode(resourceLimits, ctx);
        return resourceLimits;
    }

    @Override
    public ResourceLimit visitResourceLimit(SFMLParser.ResourceLimitContext ctx) {
        ResourceIdSet resourceIds = ctx.resourceIdDisjunction() == null ? ResourceIdSet.MATCH_ALL : this.visitResourceIdDisjunction(ctx.resourceIdDisjunction());
        Limit limit = ctx.limit() == null ? Limit.UNSET : (Limit)this.visit((ParseTree)ctx.limit());
        With with = ctx.with() == null ? With.ALWAYS_TRUE : (With)this.visit((ParseTree)ctx.with());
        ResourceLimit resourceLimit = new ResourceLimit(resourceIds, limit, with);
        this.trackNode(resourceLimit, ctx);
        return resourceLimit;
    }

    @Override
    public ASTNode visitWith(SFMLParser.WithContext ctx) {
        WithClause clause = (WithClause)this.visit((ParseTree)ctx.withClause());
        With.WithMode mode = ctx.WITHOUT() != null ? With.WithMode.WITHOUT : With.WithMode.WITH;
        With rtn = new With(clause, mode);
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public WithTag visitWithTag(SFMLParser.WithTagContext ctx) {
        WithTag rtn = new WithTag((TagMatcher)this.visit((ParseTree)ctx.tagMatcher()));
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public WithConjunction visitWithConjunction(SFMLParser.WithConjunctionContext ctx) {
        WithClause left = (WithClause)this.visit((ParseTree)ctx.withClause(0));
        WithClause right = (WithClause)this.visit((ParseTree)ctx.withClause(1));
        WithConjunction rtn = new WithConjunction(left, right);
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public WithParen visitWithParen(SFMLParser.WithParenContext ctx) {
        WithClause inner = (WithClause)this.visit((ParseTree)ctx.withClause());
        WithParen rtn = new WithParen(inner);
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public WithNegation visitWithNegation(SFMLParser.WithNegationContext ctx) {
        WithClause inner = (WithClause)this.visit((ParseTree)ctx.withClause());
        WithNegation rtn = new WithNegation(inner);
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public WithDisjunction visitWithDisjunction(SFMLParser.WithDisjunctionContext ctx) {
        WithClause left = (WithClause)this.visit((ParseTree)ctx.withClause(0));
        WithClause right = (WithClause)this.visit((ParseTree)ctx.withClause(1));
        WithDisjunction rtn = new WithDisjunction(left, right);
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public TagMatcher visitTagMatcher(SFMLParser.TagMatcherContext ctx) {
        ArrayDeque identifiers = ctx.identifier().stream().map(ParseTree::getText).map(s -> s.replaceAll("\\*", ".*")).collect(Collectors.toCollection(ArrayDeque::new));
        TagMatcher rtn = ctx.COLON() == null ? TagMatcher.fromPath(identifiers) : TagMatcher.fromNamespaceAndPath((String)identifiers.pop(), identifiers);
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public NumberRangeSet visitSlotqualifier(@Nullable SFMLParser.SlotqualifierContext ctx) {
        NumberRangeSet numberRangeSet = this.visitRangeset(ctx == null ? null : ctx.rangeset());
        if (ctx != null) {
            this.trackNode(numberRangeSet, ctx);
        }
        return numberRangeSet;
    }

    @Override
    public ForgetStatement visitForgetStatement(SFMLParser.ForgetStatementContext ctx) {
        Set<Object> labels = ctx.label().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(Label.class::cast).collect(Collectors.toSet());
        if (labels.isEmpty()) {
            labels = this.USED_LABELS;
        }
        ForgetStatement rtn = new ForgetStatement(labels);
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public NumberRangeSet visitRangeset(@Nullable SFMLParser.RangesetContext ctx) {
        if (ctx == null) {
            return NumberRangeSet.MAX_RANGE;
        }
        NumberRangeSet numberRangeSet = new NumberRangeSet((NumberRange[])ctx.range().stream().map(this::visitRange).toArray(NumberRange[]::new));
        this.trackNode(numberRangeSet, ctx);
        return numberRangeSet;
    }

    @Override
    public NumberRange visitRange(SFMLParser.RangeContext ctx) {
        PrimitiveIterator.OfLong iter = ctx.number().stream().map(this::visitNumber).mapToLong(Number::value).iterator();
        Long start = iter.next();
        if (iter.hasNext()) {
            Long end = iter.next();
            NumberRange numberRange = new NumberRange(start, end);
            this.trackNode(numberRange, ctx);
            return numberRange;
        }
        NumberRange numberRange = new NumberRange(start, start);
        this.trackNode(numberRange, ctx);
        return numberRange;
    }

    @Override
    public Limit visitRetentionLimit(SFMLParser.RetentionLimitContext ctx) {
        ResourceQuantity retain = this.visitRetention(ctx.retention());
        Limit limit = new Limit(ResourceQuantity.UNSET, retain);
        this.trackNode(limit, ctx);
        return limit;
    }

    @Override
    public Limit visitQuantityLimit(SFMLParser.QuantityLimitContext ctx) {
        ResourceQuantity quantity = this.visitQuantity(ctx.quantity());
        Limit limit = new Limit(quantity, ResourceQuantity.UNSET);
        this.trackNode(limit, ctx);
        return limit;
    }

    @Override
    public ResourceQuantity visitRetention(@Nullable SFMLParser.RetentionContext ctx) {
        if (ctx == null) {
            return ResourceQuantity.UNSET;
        }
        ResourceQuantity quantity = new ResourceQuantity(this.visitNumber(ctx.number()), ctx.EACH() != null ? ResourceQuantity.IdExpansionBehaviour.EXPAND : ResourceQuantity.IdExpansionBehaviour.NO_EXPAND);
        this.trackNode(quantity, ctx);
        return quantity;
    }

    @Override
    public ResourceQuantity visitQuantity(@Nullable SFMLParser.QuantityContext ctx) {
        if (ctx == null) {
            return ResourceQuantity.MAX_QUANTITY;
        }
        ResourceQuantity quantity = new ResourceQuantity(this.visitNumber(ctx.number()), ctx.EACH() != null ? ResourceQuantity.IdExpansionBehaviour.EXPAND : ResourceQuantity.IdExpansionBehaviour.NO_EXPAND);
        this.trackNode(quantity, ctx);
        return quantity;
    }

    @Override
    public SideQualifier visitEachSide(SFMLParser.EachSideContext ctx) {
        SideQualifier rtn = SideQualifier.ALL;
        this.trackNode(rtn, ctx);
        return rtn;
    }

    @Override
    public SideQualifier visitListedSides(SFMLParser.ListedSidesContext ctx) {
        SideQualifier sideQualifier = new SideQualifier(ctx.side().stream().map(this::visitSide).toList());
        this.trackNode(sideQualifier, ctx);
        return sideQualifier;
    }

    @Override
    public Side visitSide(SFMLParser.SideContext ctx) {
        Side side = Side.valueOf(ctx.getText().toUpperCase(Locale.ROOT));
        this.trackNode(side, ctx);
        return side;
    }

    @Override
    public Block visitBlock(@Nullable SFMLParser.BlockContext ctx) {
        if (ctx == null) {
            return new Block(Collections.emptyList());
        }
        List<Statement> statements = ctx.statement().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(Statement.class::cast).collect(Collectors.toList());
        Block block = new Block(statements);
        this.trackNode(block, ctx);
        return block;
    }

    private void trackNode(ASTNode node, ParserRuleContext ctx) {
        WeakReference<ASTNode> nodeRef = new WeakReference<ASTNode>(node);
        this.AST_NODE_CONTEXTS.add((Pair<WeakReference<ASTNode>, ParserRuleContext>)new Pair(nodeRef, (Object)ctx));
    }
}

