/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.item;

import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundNetworkToolUsePacket;
import ca.teamdman.sfm.common.registry.SFMDataComponents;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.util.CompressedBlockPosSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class NetworkToolItem
extends Item {
    public NetworkToolItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext pContext) {
        if (!pContext.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        SFMPackets.sendToServer(new ServerboundNetworkToolUsePacket(pContext.getClickedPos(), pContext.getClickedFace()));
        return InteractionResult.CONSUME;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> lines, TooltipFlag pTooltipFlag) {
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_1.getComponent().withStyle(ChatFormatting.GRAY));
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_2.getComponent().withStyle(ChatFormatting.GRAY));
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_3.getComponent(((KeyMapping)SFMKeyMappings.CONTAINER_INSPECTOR_KEY.get()).getTranslatedKeyMessage()).withStyle(ChatFormatting.AQUA));
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_4.getComponent().withStyle(ChatFormatting.LIGHT_PURPLE));
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_5.getComponent().withStyle(ChatFormatting.LIGHT_PURPLE));
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_6.getComponent().withStyle(ChatFormatting.LIGHT_PURPLE));
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_7.getComponent().withStyle(ChatFormatting.LIGHT_PURPLE));
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        boolean shouldRefresh;
        boolean isInHand;
        if (pLevel.isClientSide) {
            return;
        }
        if (!(pEntity instanceof Player)) {
            return;
        }
        Player pPlayer = (Player)pEntity;
        boolean bl = isInHand = pStack == pPlayer.getMainHandItem() || pStack == pPlayer.getOffhandItem();
        if (!isInHand) {
            return;
        }
        boolean bl2 = shouldRefresh = pEntity.tickCount % 20 == 0;
        if (!shouldRefresh) {
            return;
        }
        long maxDistance = 128L;
        Set<BlockPos> cablePositions = CableNetworkManager.getNetworksInRange(pLevel, pEntity.blockPosition(), 128.0).flatMap(CableNetwork::getCablePositions).collect(Collectors.toSet());
        NetworkToolItem.setCablePositions(pStack, cablePositions);
        Set<BlockPos> capabilityProviderPositions = CableNetworkManager.getNetworksInRange(pLevel, pEntity.blockPosition(), 128.0).flatMap(CableNetwork::getCapabilityProviderPositions).collect(Collectors.toSet());
        NetworkToolItem.setCapabilityProviderPositions(pStack, capabilityProviderPositions);
    }

    public static boolean getOverlayEnabled(ItemStack stack) {
        return !Boolean.FALSE.equals(stack.get(SFMDataComponents.OVERLAY_ENABLED));
    }

    public static void setOverlayEnabled(ItemStack stack, boolean value) {
        if (value) {
            stack.remove(SFMDataComponents.OVERLAY_ENABLED);
        } else {
            stack.set(SFMDataComponents.OVERLAY_ENABLED, (Object)false);
        }
    }

    public static void setCablePositions(ItemStack stack, Set<BlockPos> positions) {
        stack.set(SFMDataComponents.CABLE_POSITIONS, (Object)CompressedBlockPosSet.from(positions));
    }

    public static Set<BlockPos> getCablePositions(ItemStack stack) {
        return ((CompressedBlockPosSet)stack.getOrDefault(SFMDataComponents.CABLE_POSITIONS, (Object)new CompressedBlockPosSet())).into();
    }

    public static void setCapabilityProviderPositions(ItemStack stack, Set<BlockPos> positions) {
        stack.set(SFMDataComponents.CAPABILITY_POSITIONS, (Object)CompressedBlockPosSet.from(positions));
    }

    public static Set<BlockPos> getCapabilityProviderPositions(ItemStack stack) {
        return ((CompressedBlockPosSet)stack.getOrDefault(SFMDataComponents.CAPABILITY_POSITIONS, (Object)new CompressedBlockPosSet())).into();
    }
}

