/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen.text_editor;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.registry.SFMTextEditorActions;
import ca.teamdman.sfm.client.screen.SFMFontUtils;
import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.client.screen.SFMScreenRenderUtils;
import ca.teamdman.sfm.client.screen.SFMTextEditorConfigScreen;
import ca.teamdman.sfm.client.screen.text_editor.ISFMTextEditScreen;
import ca.teamdman.sfm.client.text_editor.Caret;
import ca.teamdman.sfm.client.text_editor.Cursor;
import ca.teamdman.sfm.client.text_editor.ISFMTextEditScreenOpenContext;
import ca.teamdman.sfm.client.text_editor.TextEditContext;
import ca.teamdman.sfm.client.text_editor.action.ITextEditAction;
import ca.teamdman.sfm.client.text_editor.action.KeyboardImpulse;
import ca.teamdman.sfm.client.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.LinkedList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class SFMTextEditScreenV2
extends Screen
implements ISFMTextEditScreen {
    @Nullable
    private final Screen previousScreen;
    protected TextEditContext textEditContext;
    protected ISFMTextEditScreenOpenContext openContext;

    public SFMTextEditScreenV2(ISFMTextEditScreenOpenContext openContext, @Nullable Screen previousScreen) {
        super((Component)LocalizationKeys.TEXT_EDIT_SCREEN_TITLE.getComponent());
        this.openContext = openContext;
        this.previousScreen = previousScreen;
        this.textEditContext = new TextEditContext(openContext.initialValue());
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        ITextEditAction[] matchedActions;
        if (pKeyCode == 256 && this.shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        KeyboardImpulse impulse = new KeyboardImpulse(pKeyCode, pScanCode, pModifiers);
        for (ITextEditAction matchedAction : matchedActions = (ITextEditAction[])SFMTextEditorActions.getTextEditActions().filter(action -> action.matches(this.textEditContext, impulse)).toArray(ITextEditAction[]::new)) {
            SFM.LOGGER.debug("Matched action: {}", (Object)matchedAction.getClass().getSimpleName());
            matchedAction.apply(this.textEditContext, impulse);
        }
        return matchedActions.length > 0;
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        String text = Character.toString(pCodePoint);
        this.textEditContext.insertTextAtCursors(text);
        return true;
    }

    public boolean shouldShowLineNumbers() {
        return (Boolean)SFMConfig.getOrDefault(SFMConfig.CLIENT_TEXT_EDITOR_CONFIG.showLineNumbers);
    }

    @MCVersionDependentBehaviour
    @Nullable
    public PanoramaRenderer getPanorama() {
        return PANORAMA;
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        PanoramaRenderer panorama = this.getPanorama();
        if (panorama != null) {
            panorama.render(pGuiGraphics, this.width, this.height, 1.0f, Mth.clamp((float)1.0f, (float)0.0f, (float)1.0f));
        }
        Matrix4f matrix4f = pGuiGraphics.pose().last().pose();
        LinkedList<StringBuilder> lines = this.textEditContext.lines();
        int numLines = lines.size();
        MultiBufferSource.BufferSource buffer = pGuiGraphics.bufferSource();
        boolean shouldShowLineNumbers = this.shouldShowLineNumbers();
        int marginForLineNumber = this.shouldShowLineNumbers() ? this.font.width("000") + 4 : 0;
        for (int lineIndex = 0; lineIndex < numLines; ++lineIndex) {
            StringBuilder line = lines.get(lineIndex);
            Objects.requireNonNull(this.font);
            int lineHeight = 9;
            if (shouldShowLineNumbers) {
                SFMFontUtils.drawInBatch((Component)Component.literal((String)String.format("%03d", lineIndex + 1)).withStyle(ChatFormatting.GRAY), this.font, 0.0f, (float)(lineIndex * lineHeight), true, false, matrix4f, (MultiBufferSource)buffer);
            }
            SFMFontUtils.drawInBatch(line.toString(), this.font, (float)marginForLineNumber, (float)(lineIndex * lineHeight), true, false, matrix4f, (MultiBufferSource)buffer);
        }
        buffer.endBatch();
        Int2ObjectOpenHashMap<IntervalSet> selectedCharactersByLine = this.textEditContext.selectedCharactersByLine();
        for (int lineIndex = 0; lineIndex < numLines; ++lineIndex) {
            @Nullable IntervalSet selectedCharacters = (IntervalSet)selectedCharactersByLine.get(lineIndex);
            StringBuilder line = lines.get(lineIndex);
            if (selectedCharacters == null || selectedCharacters.isNil()) continue;
            for (Interval interval : selectedCharacters.getIntervals()) {
                int selectionStartX = this.font.width(line.substring(0, interval.a)) + marginForLineNumber;
                int selectionEndX = this.font.width(line.substring(0, interval.b + 1)) + marginForLineNumber;
                Objects.requireNonNull(this.font);
                int selectionY = lineIndex * 9;
                Objects.requireNonNull(this.font);
                SFMScreenRenderUtils.renderHighlight(pGuiGraphics, selectionStartX, selectionY, selectionEndX, selectionY + 9);
            }
        }
        for (Cursor cursor : this.textEditContext.multiCursor().cursors()) {
            Caret head = cursor.head();
            Caret tail = cursor.tail();
            int headX = this.font.width(lines.get(head.lineIndex()).substring(0, head.gapIndex())) + marginForLineNumber;
            int tailX = this.font.width(lines.get(tail.lineIndex()).substring(0, tail.gapIndex())) + marginForLineNumber;
            int n = head.lineIndex();
            Objects.requireNonNull(this.font);
            int headY = n * 9;
            int n2 = tail.lineIndex();
            Objects.requireNonNull(this.font);
            int tailY = n2 * 9;
            this.renderCursor(pGuiGraphics, headX, headY, FastColor.ARGB32.color((int)127, (int)255, (int)0, (int)0));
            this.renderCursor(pGuiGraphics, tailX, tailY, FastColor.ARGB32.color((int)127, (int)0, (int)0, (int)255));
        }
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void onClose() {
        this.openContext.onTryClose(this.textEditContext.getContent(), () -> SFMScreenChangeHelpers.setScreen(this.previousScreen));
    }

    @Override
    public ISFMTextEditScreenOpenContext openContext() {
        return this.openContext;
    }

    @Override
    public ISFMTextEditScreen.OpenBehaviour openBehaviour() {
        return ISFMTextEditScreen.OpenBehaviour.Replace;
    }

    protected void renderCursor(GuiGraphics guiGraphics, int x, int y, int color) {
        Objects.requireNonNull(this.font);
        guiGraphics.fill(x, y, x + 2, y + 9, color);
    }

    protected void init() {
        super.init();
        SFMScreenRenderUtils.enableKeyRepeating();
        this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition(4, this.height - 24).setSize(16, 20).setText((Component)Component.literal((String)"#")).setOnPress(button -> SFMScreenChangeHelpers.setOrPushScreen(new SFMTextEditorConfigScreen(this, SFMConfig.CLIENT_TEXT_EDITOR_CONFIG, () -> {}))).setTooltip((Screen)this, this.font, LocalizationKeys.PROGRAM_EDIT_SCREEN_CONFIG_BUTTON_TOOLTIP).build());
    }

    protected void renderTooltip(PoseStack pose, int mx, int my) {
        if (this.minecraft != null && this.minecraft.screen != this) {
            this.renderables.stream().filter(AbstractWidget.class::isInstance).map(AbstractWidget.class::cast).forEach(w -> w.setFocused(false));
            return;
        }
        this.drawChildTooltips(pose, mx, my);
    }

    @MCVersionDependentBehaviour
    private void drawChildTooltips(PoseStack pose, int mx, int my) {
    }
}

