/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.registry;

import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforgespi.language.IModFileInfo;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="sfm", value={Dist.CLIENT})
public class SFMPackFinders {
    private static final String CLASSIC_PACK_PATH = "pack/classic";
    private static final String CLASSIC_PACK_ID = "sfm:classic";
    private static final String CLASSIC_PACK_DISPLAY_NAME = "SFM Classic";

    @SubscribeEvent
    @MCVersionDependentBehaviour
    public static void onRegisterPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        IModFileInfo modFileInfo = ModList.get().getModFileById("sfm");
        if (modFileInfo == null) {
            return;
        }
        Path classicRoot = modFileInfo.getFile().findResource(new String[]{CLASSIC_PACK_PATH});
        if (!Files.exists(classicRoot.resolve("pack.mcmeta"), new LinkOption[0])) {
            return;
        }
        event.addRepositorySource(consumer -> {
            PackLocationInfo packLocationInfo = new PackLocationInfo(CLASSIC_PACK_ID, (Component)Component.literal((String)CLASSIC_PACK_DISPLAY_NAME), PackSource.BUILT_IN, Optional.empty());
            final PathPackResources packResources = new PathPackResources(packLocationInfo, classicRoot);
            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)packLocationInfo, (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

                public PackResources openPrimary(PackLocationInfo pLocation) {
                    return packResources;
                }

                public PackResources openFull(PackLocationInfo pLocation, Pack.Metadata pMetadata) {
                    return packResources;
                }
            }, (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(false, Pack.Position.TOP, false));
            consumer.accept(pack);
        });
    }
}

