/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.unrealdinnerbone.jamd.ConfigCodec;
import com.unrealdinnerbone.jamd.JAMD;
import com.unrealdinnerbone.jamd.JAMDRegistry;
import com.unrealdinnerbone.jamd.OresCodec;
import com.unrealdinnerbone.jamd.WorldType;
import com.unrealdinnerbone.jamd.util.Transformers;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.slf4j.Logger;

public class OreRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<WorldType, List<PlacedFeature>> REGISTERED_FEATURES = new HashMap<WorldType, List<PlacedFeature>>();

    public static List<PlacedFeature> getFeatures(Holder<Biome> biomeHolder) {
        if (biomeHolder.is(JAMDRegistry.OVERWORLD.getKey().biome())) {
            return OreRegistry.getFeatures(JAMDRegistry.OVERWORLD);
        }
        if (biomeHolder.is(JAMDRegistry.NETHER.getKey().biome())) {
            return OreRegistry.getFeatures(JAMDRegistry.NETHER);
        }
        if (biomeHolder.is(JAMDRegistry.END.getKey().biome())) {
            return OreRegistry.getFeatures(JAMDRegistry.END);
        }
        return Collections.emptyList();
    }

    public static List<PlacedFeature> getFeatures(WorldType type) {
        if (!REGISTERED_FEATURES.containsKey(type)) {
            try {
                ArrayList<PlacedFeature> features;
                Path resolve = JAMD.CONFIG_FOLDER.resolve(type.getName() + ".json");
                if (!Files.exists(resolve, new LinkOption[0])) {
                    return Collections.emptyList();
                }
                String jsonString = Files.readString(resolve);
                JsonElement parse = new JsonParser().parse(jsonString);
                DataResult data = ConfigCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)parse);
                if (data.error().isPresent()) {
                    LOGGER.error("Failed to parse ConfigCodec json: {}", (Object)((DataResult.Error)data.error().get()).message());
                    return Collections.emptyList();
                }
                Optional result = data.result();
                if (result.isPresent()) {
                    features = new ArrayList<PlacedFeature>();
                    ConfigCodec configCodec = (ConfigCodec)result.get();
                    for (int i = 0; i < configCodec.oreMultiplier(); ++i) {
                        for (OresCodec ore : configCodec.ores()) {
                            features.add(Transformers.fromConfigCodec(ore, configCodec.ignoreAirChance()));
                        }
                    }
                } else {
                    LOGGER.error("Failed to parse config: {}", (Object)"No result");
                    return Collections.emptyList();
                }
                REGISTERED_FEATURES.put(type, features);
            }
            catch (IOException e) {
                LOGGER.error("Failed to read config file", (Throwable)e);
            }
        }
        return REGISTERED_FEATURES.get(type);
    }
}

