/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import appeng.core.network.CustomAppEngPayload;
import appeng.core.network.ServerboundPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.pedroksl.advanced_ae.gui.QuantumCrafterConfigPatternMenu;

public record SetStockAmountPacket(int index, long amount) implements ServerboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, SetStockAmountPacket> STREAM_CODEC = StreamCodec.ofMember(SetStockAmountPacket::write, SetStockAmountPacket::decode);
    public static final CustomPacketPayload.Type<SetStockAmountPacket> TYPE = CustomAppEngPayload.createType((String)"aae_set_stock_amount");

    public CustomPacketPayload.Type<SetStockAmountPacket> type() {
        return TYPE;
    }

    public static SetStockAmountPacket decode(RegistryFriendlyByteBuf stream) {
        int index = stream.readInt();
        long amount = stream.readLong();
        return new SetStockAmountPacket(index, amount);
    }

    public void write(RegistryFriendlyByteBuf data) {
        data.writeInt(this.index);
        data.writeLong(this.amount);
    }

    public void handleOnServer(ServerPlayer serverPlayer) {
        AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
        if (abstractContainerMenu instanceof QuantumCrafterConfigPatternMenu) {
            QuantumCrafterConfigPatternMenu menu = (QuantumCrafterConfigPatternMenu)abstractContainerMenu;
            menu.setStockAmount(this.index, this.amount);
        }
    }
}

