/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import appeng.core.network.ClientboundPacket;
import appeng.core.network.CustomAppEngPayload;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterScreen;

public record PatternsUpdatePacket(List<Boolean> invalidPatterns, List<Boolean> enabledPatterns) implements ClientboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, PatternsUpdatePacket> STREAM_CODEC = StreamCodec.ofMember(PatternsUpdatePacket::write, PatternsUpdatePacket::decode);
    public static final CustomPacketPayload.Type<PatternsUpdatePacket> TYPE = CustomAppEngPayload.createType((String)"aae_crafter_enabled_buttons");

    public CustomPacketPayload.Type<PatternsUpdatePacket> type() {
        return TYPE;
    }

    public static PatternsUpdatePacket decode(RegistryFriendlyByteBuf stream) {
        int x;
        ArrayList<Boolean> invalidList = new ArrayList<Boolean>();
        ArrayList<Boolean> enabledList = new ArrayList<Boolean>();
        int size = stream.readInt();
        for (x = 0; x < size; ++x) {
            invalidList.add(stream.readBoolean());
        }
        size = stream.readInt();
        for (x = 0; x < size; ++x) {
            enabledList.add(stream.readBoolean());
        }
        return new PatternsUpdatePacket(invalidList, enabledList);
    }

    public void write(RegistryFriendlyByteBuf data) {
        data.writeInt(this.invalidPatterns.size());
        for (Boolean entry : this.invalidPatterns) {
            data.writeBoolean(entry.booleanValue());
        }
        data.writeInt(this.enabledPatterns.size());
        for (Boolean entry : this.enabledPatterns) {
            data.writeBoolean(entry.booleanValue());
        }
    }

    public void handleOnClient(Player player) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof QuantumCrafterScreen) {
            QuantumCrafterScreen screen2 = (QuantumCrafterScreen)screen;
            screen2.updateInvalidButtons(this.invalidPatterns);
            screen2.updateEnabledButtons(this.enabledPatterns);
        }
    }
}

