/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.worldgen.tree.deco;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.starfruit.ratatouillefrieddelights.content.colafruit.ColaFruitBlock;
import org.starfruit.ratatouillefrieddelights.entry.RFDBlocks;
import org.starfruit.ratatouillefrieddelights.worldgen.tree.deco.RFDTreeDecoratorTypes;

public class ColaFruitDecorator
extends TreeDecorator {
    public static final MapCodec<ColaFruitDecorator> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.FLOAT.fieldOf("chance").forGetter(d -> Float.valueOf(d.chance)), (App)Codec.INT.fieldOf("max_per_tree").forGetter(d -> d.maxPerTree)).apply((Applicative)inst, ColaFruitDecorator::new));
    private final float chance;
    private final int maxPerTree;

    public ColaFruitDecorator(float chance, int maxPerTree) {
        this.chance = chance;
        this.maxPerTree = maxPerTree;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)RFDTreeDecoratorTypes.COLA_FRUIT.get();
    }

    public void place(TreeDecorator.Context ctx) {
        RandomSource rand = ctx.random();
        int placed = 0;
        for (BlockPos leafPos : ctx.leaves()) {
            BlockPos below;
            if (placed >= this.maxPerTree) break;
            if (rand.nextFloat() > this.chance || !ctx.isAir(below = leafPos.below())) continue;
            BlockState fruit = (BlockState)((ColaFruitBlock)((Object)RFDBlocks.COLA_FRUIT_BLOCK.get())).defaultBlockState().setValue((Property)ColaFruitBlock.AGE, (Comparable)Integer.valueOf(0));
            ctx.setBlock(below, fruit);
            ++placed;
        }
    }
}

