/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.worldgen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.starfruit.ratatouillefrieddelights.entry.RFDBlocks;
import org.starfruit.ratatouillefrieddelights.worldgen.RFDConfiguredFeatures;

public class RFDPlacedFeatures {
    public static final ResourceKey<PlacedFeature> COLA_TREE_KEY = RFDPlacedFeatures.registerKey("cola_tree");

    public static void bootstrap(BootstrapContext<PlacedFeature> ctx) {
        HolderGetter configured = ctx.lookup(Registries.CONFIGURED_FEATURE);
        ctx.register(COLA_TREE_KEY, (Object)new PlacedFeature((Holder)configured.getOrThrow(RFDConfiguredFeatures.COLA), (List)Util.make(new ArrayList(), list -> {
            list.addAll(VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)2, (float)0.05f, (int)1), (Block)((Block)RFDBlocks.COLA_SAPLING.get())));
            list.add(BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.wouldSurvive((BlockState)((SaplingBlock)RFDBlocks.COLA_SAPLING.get()).defaultBlockState(), (Vec3i)BlockPos.ZERO)));
            list.add(HeightmapPlacement.onHeightmap((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES));
        })));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ratatouille_fried_delights", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

