/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.entry;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.starfruit.ratatouillefrieddelights.RatatouilleFriedDelights;
import org.starfruit.ratatouillefrieddelights.content.burger.BurgerAssemblyRecipe;
import org.starfruit.ratatouillefrieddelights.content.burger.BurgerSaucingRecipe;
import org.starfruit.ratatouillefrieddelights.content.continuousfryer.FryingRecipe;
import org.starfruit.ratatouillefrieddelights.content.drumprocessor.CoatingRecipe;
import org.starfruit.ratatouillefrieddelights.content.drumprocessor.TumblingRecipe;

public enum RFDRecipeTypes implements IRecipeTypeInfo
{
    COATING(CoatingRecipe::new),
    TUMBLING(TumblingRecipe::new),
    FRYING(FryingRecipe::new),
    BURGER_ASSEMBLY(() -> new ItemApplicationRecipe.Serializer(BurgerAssemblyRecipe::new), () -> ((AllRecipeTypes)AllRecipeTypes.DEPLOYING).getType(), false),
    BURGER_SAUCING(() -> new StandardProcessingRecipe.Serializer(BurgerSaucingRecipe::new), () -> ((AllRecipeTypes)AllRecipeTypes.FILLING).getType(), false);

    private final ResourceLocation id;
    private final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> serializerObject;
    @Nullable
    private final DeferredHolder<RecipeType<?>, RecipeType<?>> typeObject;
    private final Supplier<RecipeType<?>> type;
    public final Supplier<RecipeSerializer<?>> serializerSupplier;

    private RFDRecipeTypes(StandardProcessingRecipe.Factory<?> processingFactory) {
        this(() -> new StandardProcessingRecipe.Serializer(processingFactory));
    }

    private RFDRecipeTypes(Supplier<RecipeSerializer<?>> serializerSupplier) {
        String name = Lang.asId((String)this.name());
        this.id = RatatouilleFriedDelights.asResource(name);
        this.serializerSupplier = serializerSupplier;
        this.serializerObject = Registers.SERIALIZER_REGISTER.register(name, serializerSupplier);
        this.typeObject = Registers.TYPE_REGISTER.register(name, () -> RecipeType.simple((ResourceLocation)this.id));
        this.type = this.typeObject;
    }

    private RFDRecipeTypes(Supplier<RecipeSerializer<?>> serializerSupplier, Supplier<RecipeType<?>> typeSupplier, boolean registerType) {
        String name = Lang.asId((String)this.name());
        this.id = RatatouilleFriedDelights.asResource(name);
        this.serializerSupplier = serializerSupplier;
        this.serializerObject = Registers.SERIALIZER_REGISTER.register(name, serializerSupplier);
        if (registerType) {
            this.typeObject = Registers.TYPE_REGISTER.register(name, typeSupplier);
            this.type = this.typeObject;
        } else {
            this.typeObject = null;
            this.type = typeSupplier;
        }
    }

    public static void register(IEventBus modEventBus) {
        ShapedRecipePattern.setCraftingSize((int)9, (int)9);
        Registers.SERIALIZER_REGISTER.register(modEventBus);
        Registers.TYPE_REGISTER.register(modEventBus);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public <T extends RecipeSerializer<?>> T getSerializer() {
        return (T)((RecipeSerializer)this.serializerObject.get());
    }

    public <I extends RecipeInput, R extends Recipe<I>> RecipeType<R> getType() {
        return this.type.get();
    }

    public <I extends RecipeInput, R extends Recipe<I>> Optional<RecipeHolder<R>> find(I inv, Level world) {
        return world.getRecipeManager().getRecipeFor(this.getType(), inv, world);
    }

    @Nullable
    public static FryingRecipe findFryingRecipe(Level level, ItemStack item, FluidStack fluid, BlazeBurnerBlock.HeatLevel heatLevel) {
        if (level == null || item.isEmpty() || fluid.isEmpty()) {
            return null;
        }
        return level.getRecipeManager().getAllRecipesFor(FRYING.getType()).stream().map(RecipeHolder::value).filter(recipe -> {
            FryingRecipe frying;
            return recipe instanceof FryingRecipe && (frying = (FryingRecipe)((Object)recipe)).matches(item, fluid, heatLevel);
        }).map(recipe -> (FryingRecipe)((Object)recipe)).findFirst().orElse(null);
    }

    private static class Registers {
        private static final DeferredRegister<RecipeSerializer<?>> SERIALIZER_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"ratatouille_fried_delights");
        private static final DeferredRegister<RecipeType<?>> TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"ratatouille_fried_delights");

        private Registers() {
        }
    }
}

