/*
 * Decompiled with CFR 0.152.
 */
package org.starfruit.ratatouillefrieddelights.data.recipe;

import com.google.common.base.Supplier;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import org.forsteri.ratatouille.entry.CRItems;
import org.starfruit.ratatouillefrieddelights.RatatouilleFriedDelights;
import org.starfruit.ratatouillefrieddelights.entry.RFDBlocks;
import org.starfruit.ratatouillefrieddelights.entry.RFDItems;
import vectorwing.farmersdelight.common.registry.ModItems;

public final class RFDStandardRecipeGen
extends BaseRecipeProvider {
    final List<BaseRecipeProvider.GeneratedRecipe> all = new ArrayList<BaseRecipeProvider.GeneratedRecipe>();
    BaseRecipeProvider.GeneratedRecipe TOP_BURGER_BUN = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)RFDItems.TOP_BURGER_BUN).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> RFDItems.BURGER_BUN.asItem())).viaShapeless(b -> b.requires((ItemLike)RFDItems.BOTTOM_BURGER_BUN.get()));
    BaseRecipeProvider.GeneratedRecipe BOTTOM_BURGER_BUN = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)RFDItems.BOTTOM_BURGER_BUN).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> RFDItems.BURGER_BUN.asItem())).viaShapeless(b -> b.requires((ItemLike)RFDItems.TOP_BURGER_BUN.get()));
    BaseRecipeProvider.GeneratedRecipe BREADED_ORIGINAL_DRUMSTICK = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)RFDItems.BREADED_ORIGINAL_DRUMSTICK).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> RFDItems.BATTERED_ORIGINAL_DRUMSTICK.asItem())).viaShapeless(b -> b.requires((ItemLike)RFDItems.BATTERED_ORIGINAL_DRUMSTICK.get()).requires((ItemLike)RFDItems.BREADCRUMB.get()));
    BaseRecipeProvider.GeneratedRecipe BREADED_ORIGINAL_KEEL = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)RFDItems.BREADED_ORIGINAL_KEEL).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> RFDItems.BATTERED_ORIGINAL_KEEL.asItem())).viaShapeless(b -> b.requires((ItemLike)RFDItems.BATTERED_ORIGINAL_KEEL.get()).requires((ItemLike)RFDItems.BREADCRUMB.get()));
    BaseRecipeProvider.GeneratedRecipe SUNFLOWER_SEEDS = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)RFDItems.SUNFLOWER_SEEDS).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((Item)Items.SUNFLOWER).asItem())).viaShapeless(b -> b.requires((ItemLike)Items.SUNFLOWER));
    BaseRecipeProvider.GeneratedRecipe COLA_NUTS = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)RFDItems.COLA_NUTS).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> RFDItems.COLA_FRUITS.asItem())).viaShapeless(b -> b.requires(RFDItems.COLA_FRUITS));
    BaseRecipeProvider.GeneratedRecipe COLA_PLANKS = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)RFDBlocks.COLA_PLANKS).returns(4).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> RFDBlocks.COLA_LOG.asItem())).viaShapeless(b -> b.requires(RFDBlocks.COLA_LOG));
    BaseRecipeProvider.GeneratedRecipe SECRET_SEASONING_POWDER = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)RFDItems.SECRET_SEASONING_POWDER).returns(5).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((Item)Items.DRIED_KELP).asItem())).viaShapeless(b -> b.requires((ItemLike)AllItems.WHEAT_FLOUR.get()).requires((ItemLike)Items.BEETROOT).requires((ItemLike)Items.DRIED_KELP).requires((ItemLike)CRItems.SALT).requires((ItemLike)ModItems.ONION.get()));
    BaseRecipeProvider.GeneratedRecipe BOXED_FRIES = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)RFDBlocks.BOXED_FRIES).returns(1).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> RFDItems.FRENCH_FRIES.asItem())).viaShapeless(b -> b.requires((ItemLike)RFDItems.FRENCH_FRIES.get()).requires((ItemLike)AllItems.CARDBOARD));
    BaseRecipeProvider.GeneratedRecipe BOXED_CHICKEN_NUGGETS = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)RFDBlocks.BOXED_CHICKEN_NUGGETS).returns(1).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> RFDItems.CHICKEN_NUGGETS.asItem())).viaShapeless(b -> b.requires((ItemLike)RFDItems.CHICKEN_NUGGETS.get()).requires((ItemLike)AllItems.CARDBOARD));
    BaseRecipeProvider.GeneratedRecipe DUO_CHICKEN_BUCKET = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)RFDBlocks.DUO_CHICKEN_BUCKET).returns(1).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> RFDItems.ORIGINAL_CHICKEN_DRUMSTICK.asItem())).viaShapeless(b -> b.requires((ItemLike)RFDItems.ORIGINAL_CHICKEN_DRUMSTICK.get()).requires((ItemLike)RFDItems.ORIGINAL_CHICKEN_DRUMSTICK.get()).requires((ItemLike)RFDItems.ORIGINAL_CHICKEN_KEEL.get()).requires((ItemLike)RFDItems.ORIGINAL_CHICKEN_KEEL.get()).requires((ItemLike)AllItems.CARDBOARD));
    BaseRecipeProvider.GeneratedRecipe HOT_DOG = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)RFDItems.HOT_DOG).returns(1).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)CRItems.SAUSAGE).asItem())).viaShapeless(b -> b.requires((ItemLike)Items.BREAD).requires((ItemLike)CRItems.SAUSAGE.get()));
    BaseRecipeProvider.GeneratedRecipe TALL_CUP = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)RFDItems.TALL_CUP).returns(3).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((Item)Items.GLASS).asItem())).viaShaped(b -> b.pattern("Y Y").pattern("Y Y").pattern(" Y ").define(Character.valueOf('Y'), (ItemLike)Items.GLASS));
    BaseRecipeProvider.GeneratedRecipe CARDBOARD_STRAW = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)RFDItems.CARDBOARD_STRAW).returns(12).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((Item)Items.GLASS).asItem())).viaShaped(b -> b.pattern("Y Y").pattern("Y Y").pattern("Y Y").define(Character.valueOf('Y'), (ItemLike)AllItems.CARDBOARD));
    BaseRecipeProvider.GeneratedRecipe DRUM_PROCESSOR = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)RFDBlocks.DRUM_PROCESSOR).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((Item)Items.IRON_INGOT).asItem())).viaShaped(b -> b.pattern(" X ").pattern(" Y ").pattern(" Z ").define(Character.valueOf('X'), (ItemLike)AllBlocks.INDUSTRIAL_IRON_BLOCK).define(Character.valueOf('Y'), (ItemLike)AllBlocks.ANDESITE_CASING).define(Character.valueOf('Z'), (ItemLike)AllBlocks.SHAFT));
    BaseRecipeProvider.GeneratedRecipe CONTINUOUS_FRYER = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)RFDBlocks.CONTINUOUS_FRYER).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((Item)Items.COPPER_INGOT).asItem())).viaShaped(b -> b.pattern(" X ").pattern(" Y ").pattern(" Z ").define(Character.valueOf('X'), (ItemLike)AllBlocks.ANDESITE_LADDER).define(Character.valueOf('Y'), (ItemLike)AllBlocks.SHAFT).define(Character.valueOf('Z'), (ItemLike)AllBlocks.COPPER_CASING));
    BaseRecipeProvider.GeneratedRecipe PANCAKE_MOLD_BAKED = this.create((Supplier<ItemLike>)((Supplier)() -> RFDItems.PANCAKE_MOLD_BAKED.get())).viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> RFDItems.PANCAKE_MOLD_FILLED.get())).forDuration(200).inSmoker();
    BaseRecipeProvider.GeneratedRecipe CONE_MOLD_BAKED = this.create((Supplier<ItemLike>)((Supplier)() -> RFDItems.CONE_MOLD_BAKED.get())).viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> RFDItems.CONE_MOLD_FILLED.get())).forDuration(200).inSmoker();
    BaseRecipeProvider.GeneratedRecipe CHEESE_BAKED = this.create((Supplier<ItemLike>)((Supplier)() -> RFDItems.CHEESE.get())).viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> RFDItems.RAW_CHEESE.get())).forDuration(200).inSmoker();
    BaseRecipeProvider.GeneratedRecipe BURGER_BUN_MOLD_BAKED = this.create((Supplier<ItemLike>)((Supplier)() -> RFDItems.BURGER_BUN_MOLD_BAKED.get())).viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> RFDItems.BURGER_BUN_MOLD_UNBAKED.get())).forDuration(200).inSmoker();

    public RFDStandardRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, "ratatouille_fried_delights");
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike, ? extends ItemLike> result) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get()));
    }

    GeneratedRecipeBuilder create(Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder(result);
    }

    class GeneratedRecipeBuilder {
        List<ICondition> recipeConditions = new ArrayList<ICondition>();
        private String suffix = "";
        private Supplier<? extends ItemLike> result;
        private ResourceLocation compatDatagenOutput;
        private Supplier<ItemPredicate> unlockedBy;
        private int amount = 1;

        public GeneratedRecipeBuilder(Supplier<? extends ItemLike> result) {
            this();
            this.result = result;
        }

        private GeneratedRecipeBuilder() {
        }

        public GeneratedRecipeBuilder(ResourceLocation result) {
            this();
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder whenModLoaded(String modid) {
            return this.withCondition((ICondition)new ModLoadedCondition(modid));
        }

        GeneratedRecipeBuilder withCondition(ICondition condition) {
            this.recipeConditions.add(condition);
            return this;
        }

        GeneratedRecipeBuilder whenModMissing(String modid) {
            return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        BaseRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return RFDStandardRecipeGen.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", RFDStandardRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.save(consumer, this.createLocation("crafting"));
            });
        }

        private ResourceLocation createLocation(String recipeType) {
            return RatatouilleFriedDelights.asResource(recipeType + "/" + this.getRegistryName().getPath() + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return this.compatDatagenOutput == null ? RegisteredObjectsHelper.getKeyOrThrow((Item)((ItemLike)this.result.get()).asItem()) : this.compatDatagenOutput;
        }

        BaseRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return RFDStandardRecipeGen.this.register(recipeOutput -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", RFDStandardRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                RecipeOutput conditionalOutput = recipeOutput.withConditions(this.recipeConditions.toArray(new ICondition[0]));
                b.save(conditionalOutput, this.createLocation("crafting"));
            });
        }

        BaseRecipeProvider.GeneratedRecipe viaNetheriteSmithing(Supplier<? extends Item> base, Supplier<Ingredient> upgradeMaterial) {
            return RFDStandardRecipeGen.this.register(consumer -> {
                SmithingTransformRecipeBuilder b = SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)base.get()}), (Ingredient)((Ingredient)upgradeMaterial.get()), (RecipeCategory)RecipeCategory.COMBAT, (Item)((ItemLike)this.result.get()).asItem());
                b.unlocks("has_item", RFDStandardRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)base.get()}).build()}));
                b.save(consumer, this.createLocation("crafting"));
            });
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return RatatouilleFriedDelights.asResource(recipeType + "/" + this.getRegistryName().getPath() + this.suffix);
        }

        GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)item.get()})));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<Ingredient> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)item.get()}).build();
            return this;
        }

        GeneratedCookingRecipeBuilder viaCookingTag(Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.of((TagKey)((TagKey)tag.get()))));
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of((TagKey)tag.get()).build();
            return this;
        }

        class GeneratedCookingRecipeBuilder {
            private Supplier<Ingredient> ingredient;
            private float exp;
            private int cookingTime;

            GeneratedCookingRecipeBuilder(Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            BaseRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
            }

            private <T extends AbstractCookingRecipe> BaseRecipeProvider.GeneratedRecipe create(RecipeSerializer<T> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, AbstractCookingRecipe.Factory<T> factory, float cookingTimeModifier) {
                return RFDStandardRecipeGen.this.register(recipeOutput -> {
                    boolean isOtherMod = GeneratedRecipeBuilder.this.compatDatagenOutput != null;
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.generic((Ingredient)((Ingredient)this.ingredient.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)(isOtherMod ? Items.DIRT : (ItemLike)GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (RecipeSerializer)serializer, (AbstractCookingRecipe.Factory)factory));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.unlockedBy("has_item", RFDStandardRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    RecipeOutput conditionalOutput = recipeOutput.withConditions(GeneratedRecipeBuilder.this.recipeConditions.toArray(new ICondition[0]));
                    b.save(conditionalOutput, GeneratedRecipeBuilder.this.createSimpleLocation(RegisteredObjectsHelper.getKeyOrThrow((RecipeSerializer)serializer).getPath()));
                });
            }

            BaseRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
                this.create(RecipeSerializer.CAMPFIRE_COOKING_RECIPE, builder, CampfireCookingRecipe::new, 3.0f);
                return this.create(RecipeSerializer.SMOKING_RECIPE, builder, SmokingRecipe::new, 0.5f);
            }

            BaseRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
                return this.create(RecipeSerializer.BLASTING_RECIPE, builder, BlastingRecipe::new, 0.5f);
            }
        }
    }
}

